package io.relayr.java.model.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ProtoIoTRule implements Serializable {

    private String appId = "95758d69-2570-4add-a3a4-90a7414659db";
    protected Object comparator1;
    protected Object constant1;
    protected Object comparator2;
    protected Object constant2;
    protected Object operator;

    protected List<InputReading> inputReadings = new ArrayList<>();
    protected List<OutputCommand> outputCommands = new ArrayList<>();

    protected class InputReading implements Serializable {
        private String deviceId;
        private String meaning;

        public InputReading(String deviceId, String meaning) {
            this.deviceId = deviceId;
            this.meaning = meaning;
        }

        public String getDeviceId() {
            return deviceId;
        }

        public String getMeaning() {
            return meaning;
        }

        @Override public String toString() {
            return "InputReading{" +
                    "deviceId='" + deviceId + '\'' +
                    ", meaning='" + meaning + '\'' +
                    '}';
        }
    }

    protected class OutputCommand implements Serializable {
        private String deviceId;
        private String name;
        private Object value;

        public OutputCommand(String deviceId, String name, Object value) {
            this.deviceId = deviceId;
            this.name = name;
            this.value = value;
        }

        public String getDeviceId() {
            return deviceId;
        }

        public String getName() {
            return name;
        }

        public Object getValue() {
            return value;
        }

        @Override public String toString() {
            return "OutputCommand{" +
                    "deviceId='" + deviceId + '\'' +
                    ", name='" + name + '\'' +
                    ", value=" + value +
                    '}';
        }
    }
}
