package io.relayr.java.model.rules;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Gives a detailed view on a template in a project.
 * Also provides the latest version of this template (if it exists)
 */
public class Template implements Serializable {

    private String id;
    private String templateId;

    private String version;
    private int versionNumber;

    private String createdAt;
    private String updatedAt;

    private List<TemplateConfiguration> configuration;

    public String getId() {
        return id;
    }

    public String getTemplateId() {
        return templateId;
    }

    public String getVersion() {
        return version;
    }

    public int getVersionNumber() {
        return versionNumber;
    }

    public String getCreatedAt() {
        return createdAt;
    }

    public String getUpdatedAt() {
        return updatedAt;
    }

    public List<TemplateConfiguration> getConfiguration() {
        return configuration;
    }
}
