package io.relayr.java.model.rules;

import java.io.Serializable;

public class TemplateParameters implements Serializable {

    private String name;
    private String description;
    private boolean active = true;
    private String templateVersionId;

    private Object parameters;

    public TemplateParameters(String name, boolean active, String templateVersionId, Object parameters) {
        this.name = name;
        this.parameters = parameters;
        this.active = active;
        this.templateVersionId = templateVersionId;
    }

    public TemplateParameters(String name, String description, boolean active, String templateVersionId, Object parameters) {
        this.name = name;
        this.description = description;
        this.active = active;
        this.templateVersionId = templateVersionId;
        this.parameters = parameters;
    }

    public static TemplateParameters template(boolean active, String version) {
        return new TemplateParameters(null, active, version, null);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setTemplateVersionId(String templateVersionId) {
        this.templateVersionId = templateVersionId;
    }

    @Override public String toString() {
        return "TemplateParameters{" +
                "name='" + name + '\'' +
                ", description='" + description + '\'' +
                ", active=" + active +
                ", templateVersionId='" + templateVersionId + '\'' +
                ", parameters=" + parameters +
                '}';
    }
}
