package io.relayr.java.model.state;

import java.io.Serializable;
import java.util.List;

import io.relayr.java.model.action.Command;

public class StateCommands implements Serializable {

    private Version version;
    private List<Command> commands;

    public StateCommands(Version version, List<Command> commands) {
        this.version = version;
        this.commands = commands;
    }

    public Version getVersion() {
        return version;
    }

    public List<Command> getCommands() {
        return commands;
    }

    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        StateCommands that = (StateCommands) o;

        return version.equals(that.version);

    }

    @Override public int hashCode() {
        return version.hashCode();
    }

    @Override public String toString() {
        return "StateCommands{" +
                "version=" + version.toString() +
                ", commands=" + commands.toString() +
                '}';
    }
}
