package io.relayr.java.model.state;

import java.io.Serializable;
import java.util.List;

import io.relayr.java.model.action.Configuration;

public class StateConfigurations implements Serializable {

    private Version version;
    private List<Configuration> configurations;

    public StateConfigurations(Version version, List<Configuration> configurations) {
        this.version = version;
        this.configurations = configurations;
    }

    public List<Configuration> getConfigurations() {
        return configurations;
    }

    public Version getVersion() {
        return version;
    }

    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        StateConfigurations that = (StateConfigurations) o;

        return version.equals(that.version);
    }

    @Override public int hashCode() {
        return version.hashCode();
    }

    @Override public String toString() {
        return "StateConfigurations{" +
                "version=" + version.toString() +
                ", configurations=" + configurations.toString() +
                '}';
    }
}
