package io.relayr.java.model.state;

import java.io.Serializable;
import java.util.Map;

public class StateMetadata implements Serializable {

    private Map<String, Object> metadata;
    private Version version;

    public StateMetadata(Map<String, Object> metadata, Version version) {
        this.metadata = metadata;
        this.version = version;
    }

    public Map<String, Object> getMetadata() {
        return metadata;
    }

    public Version getVersion() {
        return version;
    }

    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        StateMetadata that = (StateMetadata) o;

        return !(version != null ? !version.equals(that.version) : that.version != null);

    }

    @Override public int hashCode() {
        return version != null ? version.hashCode() : 0;
    }
}
