package io.relayr.java.model.state;

import java.io.Serializable;
import java.util.List;

import io.relayr.java.model.action.Reading;

public class StateReadings implements Serializable {

    private Version version;
    private List<Reading> readings;

    public StateReadings(Version version, List<Reading> readings) {
        this.version = version;
        this.readings = readings;
    }

    public Version getVersion() {
        return version;
    }

    public List<Reading> getReadings() {
        return readings;
    }

    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        StateReadings that = (StateReadings) o;

        return version.equals(that.version);

    }

    @Override public int hashCode() {
        return version.hashCode();
    }

    @Override public String toString() {
        return "StateReadings{" +
                "version=" + version.toString() +
                ", readings=" + readings.toString() +
                '}';
    }
}
