package io.relayr.java.model.state;

import java.io.Serializable;

public class Version implements Serializable {

    private int number;
    private long ts;

    /**
     * Returns latest state version
     */
    public int getNumber() {
        return number;
    }

    /**
     * Returns timestamp of last update
     */
    public long getTs() {
        return ts;
    }

    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Version version = (Version) o;

        if (number != version.number) return false;
        return ts == version.ts;

    }

    @Override public int hashCode() {
        int result = number;
        result = 31 * result + (int) (ts ^ (ts >>> 32));
        return result;
    }
}
