/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol.transport.http;

import io.remotecontrol.CommandChain;
import io.remotecontrol.RemoteControlException;
import io.remotecontrol.client.Transport;
import io.remotecontrol.groovy.ContentType;
import io.remotecontrol.result.Result;
import io.remotecontrol.result.ResultFactory;
import io.remotecontrol.result.impl.DefaultResultFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpTransport
implements Transport {
    private final String receiverAddress;
    private final ClassLoader classLoader;
    private final ResultFactory resultFactory;

    public HttpTransport(String receiverAddress, ClassLoader classLoader, ResultFactory resultFactory) {
        this.classLoader = classLoader;
        this.receiverAddress = receiverAddress;
        this.resultFactory = resultFactory;
    }

    public HttpTransport(String receiverAddress, ClassLoader classLoader) {
        this(receiverAddress, classLoader, (ResultFactory)new DefaultResultFactory());
    }

    public HttpTransport(String receiverAddress) {
        this(receiverAddress, Thread.currentThread().getContextClassLoader());
    }

    public Result send(CommandChain commandChain) throws RemoteControlException {
        Result result;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            HttpURLConnection urlConnection = this.openConnection();
            urlConnection.setRequestProperty("Content-Type", ContentType.COMMAND.getValue());
            urlConnection.setRequestProperty("Accept", ContentType.RESULT.getValue());
            urlConnection.setInstanceFollowRedirects(true);
            urlConnection.setDoOutput(true);
            this.configureConnection(urlConnection);
            outputStream = urlConnection.getOutputStream();
            commandChain.writeTo(outputStream);
            inputStream = urlConnection.getInputStream();
            result = this.resultFactory.deserialize(inputStream, this.classLoader);
        }
        catch (Exception e) {
            try {
                throw new RemoteControlException((Object)("Error sending command chain to '" + String.valueOf(this.receiverAddress) + "'"), (Throwable)e);
            }
            catch (Throwable throwable) {
                for (Closeable closeable : new Closeable[]{inputStream, outputStream}) {
                    if (closeable == null) continue;
                    try {
                        closeable.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        for (Closeable closeable : new Closeable[]{inputStream, outputStream}) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    protected void configureConnection(HttpURLConnection connection) {
    }

    protected HttpURLConnection openConnection() throws IOException {
        return (HttpURLConnection)new URL(this.receiverAddress).openConnection();
    }
}

