/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol.transport.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.remotecontrol.groovy.ContentType;
import io.remotecontrol.server.Receiver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RemoteControlHttpHandler
implements HttpHandler {
    private final Receiver receiver;

    public RemoteControlHttpHandler(Receiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public void handle(HttpExchange exchange) {
        try {
            if (this.validateRequest(exchange)) {
                this.configureSuccessfulResponse(exchange);
                this.doExecute(exchange.getRequestBody(), exchange.getResponseBody());
            }
        }
        catch (IOException iOException) {
        }
        finally {
            exchange.close();
        }
    }

    protected boolean validateRequest(HttpExchange exchange) throws IOException {
        if (!exchange.getRequestMethod().equals("POST")) {
            exchange.sendResponseHeaders(415, 0L);
            exchange.getResponseBody().write("request must be a POST".getBytes("UTF-8"));
            return false;
        }
        if (!exchange.getRequestHeaders().getFirst("Content-Type").equals(ContentType.COMMAND.getValue())) {
            exchange.sendResponseHeaders(415, 0L);
            exchange.getResponseBody().write(("Content type must be " + ContentType.COMMAND).getBytes("UTF-8"));
            return false;
        }
        return true;
    }

    protected void configureSuccessfulResponse(HttpExchange exchange) throws IOException {
        exchange.getResponseHeaders().set("Content-Type", ContentType.RESULT.getValue());
        exchange.sendResponseHeaders(200, 0L);
    }

    protected void doExecute(InputStream input, OutputStream output) throws IOException {
        this.receiver.execute(input, output);
    }
}

