/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol.transport.http;

import io.remotecontrol.groovy.ContentType;
import io.remotecontrol.server.Receiver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class RemoteControlServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.validateRequest(request, response)) {
            this.configureSuccessfulResponse(response);
            this.doExecute((InputStream)request.getInputStream(), (OutputStream)response.getOutputStream());
        }
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String contentType = request.getContentType();
        if (contentType == null || !contentType.equals(ContentType.COMMAND.getValue())) {
            response.sendError(415, "Only remotecontrol control commands can be sent");
            return false;
        }
        return true;
    }

    protected void configureSuccessfulResponse(HttpServletResponse response) {
        response.setContentType(ContentType.RESULT.getValue());
    }

    protected void doExecute(InputStream input, OutputStream output) throws IOException {
        Receiver receiver = this.createReceiver();
        receiver.execute(input, output);
    }

    protected abstract Receiver createReceiver();
}

