/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android;

import android.content.Context;
import android.support.v4.content.AsyncTaskLoader;
import io.requery.EntityStore;
import io.requery.query.Result;

public abstract class QueryLoader<E>
extends AsyncTaskLoader<Result<E>> {
    private final EntityStore data;
    private Result<E> result;

    public QueryLoader(EntityStore data, Context context) {
        super(context);
        this.data = data;
    }

    protected void onStartLoading() {
        if (this.result != null) {
            this.deliverResult(this.result);
        } else {
            this.forceLoad();
        }
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
    }

    public Result<E> loadInBackground() {
        return this.performQuery(this.data);
    }

    public abstract Result<E> performQuery(EntityStore var1);

    public void deliverResult(Result<E> data) {
        if (this.isReset()) {
            if (this.result != null) {
                this.result.close();
            }
            return;
        }
        Result<E> previous = this.result;
        this.result = data;
        if (this.isStarted()) {
            super.deliverResult(this.result);
        }
        if (previous != null) {
            previous.close();
        }
    }
}

