/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlite;

import io.requery.android.sqlite.BaseConnection;
import io.requery.android.sqlite.BaseStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public abstract class BasePreparedStatement
extends BaseStatement
implements PreparedStatement {
    private static final char[] hex = "0123456789ABCDEF".toCharArray();
    protected final String sql;
    protected final int autoGeneratedKeys;
    protected List<Object> bindings;

    protected BasePreparedStatement(BaseConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        super(connection);
        if (sql == null) {
            throw new SQLException("null sql");
        }
        if (autoGeneratedKeys != 1) {
            this.bindings = new ArrayList<Object>(4);
        }
        this.sql = sql;
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    protected abstract void bindNullOrString(int var1, Object var2);

    protected abstract void bindLong(int var1, long var2);

    protected abstract void bindDouble(int var1, double var2);

    protected abstract void bindBlob(int var1, byte[] var2);

    protected String[] bindingsToArray() {
        String[] args = new String[this.bindings.size()];
        for (int i = 0; i < this.bindings.size(); ++i) {
            Object value = this.bindings.get(i);
            if (value == null) continue;
            args[i] = value.toString();
        }
        return args;
    }

    protected static String byteToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(hex[b >> 4 & 0xF]);
            sb.append(hex[b & 0xF]);
        }
        return sb.toString();
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setArray(int parameterIndex, Array theArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream theInputStream, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal theBigDecimal) throws SQLException {
        this.bindNullOrString(parameterIndex, theBigDecimal);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream theInputStream, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob theBlob) throws SQLException {
        this.setBytes(parameterIndex, theBlob.getBytes(0L, (int)theBlob.length()));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean theBoolean) throws SQLException {
        long value = theBoolean ? 1L : 0L;
        this.bindLong(parameterIndex, value);
    }

    @Override
    public void setByte(int parameterIndex, byte theByte) throws SQLException {
        this.bindLong(parameterIndex, theByte);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] theBytes) throws SQLException {
        this.bindBlob(parameterIndex, theBytes);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob theClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDate(int parameterIndex, Date theDate) throws SQLException {
        this.setDate(parameterIndex, theDate, null);
    }

    @Override
    public void setDate(int parameterIndex, Date theDate, Calendar cal) throws SQLException {
        if (theDate == null) {
            this.bindNullOrString(parameterIndex, null);
        } else {
            this.bindLong(parameterIndex, theDate.getTime());
        }
    }

    @Override
    public void setDouble(int parameterIndex, double theDouble) throws SQLException {
        this.bindDouble(parameterIndex, theDouble);
    }

    @Override
    public void setFloat(int parameterIndex, float theFloat) throws SQLException {
        this.bindDouble(parameterIndex, theFloat);
    }

    @Override
    public void setInt(int parameterIndex, int theInt) throws SQLException {
        this.bindLong(parameterIndex, theInt);
    }

    @Override
    public void setLong(int parameterIndex, long theLong) throws SQLException {
        this.bindLong(parameterIndex, theLong);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.bindNullOrString(parameterIndex, null);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.bindNullOrString(paramIndex, null);
    }

    @Override
    public void setObject(int parameterIndex, Object theObject) throws SQLException {
        if (theObject == null) {
            this.setNull(parameterIndex, 0);
        } else if (theObject instanceof String) {
            this.setString(parameterIndex, theObject.toString());
        } else if (theObject instanceof Byte) {
            this.setByte(parameterIndex, (Byte)theObject);
        } else if (theObject instanceof Short) {
            this.setShort(parameterIndex, (Short)theObject);
        } else if (theObject instanceof Integer) {
            this.setInt(parameterIndex, (Integer)theObject);
        } else if (theObject instanceof Long) {
            this.setLong(parameterIndex, (Long)theObject);
        } else if (theObject instanceof Double) {
            this.setDouble(parameterIndex, (Double)theObject);
        } else if (theObject instanceof Float) {
            this.setFloat(parameterIndex, ((Float)theObject).floatValue());
        } else if (theObject instanceof Boolean) {
            this.setLong(parameterIndex, (Boolean)theObject != false ? 1L : 0L);
        } else if (theObject instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])theObject);
        } else if (theObject instanceof Date) {
            this.setDate(parameterIndex, (Date)theObject);
        } else if (theObject instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)theObject;
            this.setDate(parameterIndex, new Date(date.getTime()));
        } else {
            throw new SQLException("unhandled type " + theObject.getClass().getCanonicalName());
        }
    }

    @Override
    public void setObject(int parameterIndex, Object theObject, int targetSqlType) throws SQLException {
        if (theObject == null || targetSqlType == 0) {
            this.setNull(parameterIndex, 0);
            return;
        }
        switch (targetSqlType) {
            case 4: 
            case 5: {
                if (theObject instanceof Integer) {
                    this.bindLong(parameterIndex, ((Integer)theObject).longValue());
                    break;
                }
                if (theObject instanceof Long) {
                    this.bindLong(parameterIndex, (Long)theObject);
                    break;
                }
                if (!(theObject instanceof Short)) break;
                this.bindLong(parameterIndex, ((Short)theObject).longValue());
                break;
            }
            case -6: {
                if (!(theObject instanceof Byte)) break;
                this.bindLong(parameterIndex, ((Byte)theObject).longValue());
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (theObject instanceof Double) {
                    this.setDouble(parameterIndex, (Double)theObject);
                    break;
                }
                if (!(theObject instanceof Float)) break;
                this.setFloat(parameterIndex, ((Float)theObject).floatValue());
                break;
            }
            case -3: 
            case -2: 
            case 2004: {
                this.setBytes(parameterIndex, (byte[])theObject);
                break;
            }
            case 16: {
                Boolean value = (Boolean)theObject;
                this.setBoolean(parameterIndex, value);
                break;
            }
            case -9: 
            case 12: {
                String string = theObject instanceof String ? (String)theObject : theObject.toString();
                this.setString(parameterIndex, string);
                break;
            }
            case 91: {
                if (theObject instanceof Date) {
                    Date date = (Date)theObject;
                    this.setLong(parameterIndex, date.getTime());
                    break;
                }
                if (!(theObject instanceof java.util.Date)) break;
                java.util.Date date = (java.util.Date)theObject;
                this.setLong(parameterIndex, date.getTime());
                break;
            }
            case 93: {
                if (!(theObject instanceof Timestamp)) break;
                Timestamp timestamp = (Timestamp)theObject;
                this.setLong(parameterIndex, timestamp.getTime());
                break;
            }
            case -5: {
                if (!(theObject instanceof BigInteger)) break;
                BigInteger bigInteger = (BigInteger)theObject;
                this.bindNullOrString(parameterIndex, bigInteger.toString());
                break;
            }
            default: {
                throw new SQLException("unhandled type " + targetSqlType);
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object theObject, int targetSqlType, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int parameterIndex, Ref theRef) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setShort(int parameterIndex, short theShort) throws SQLException {
        this.bindLong(parameterIndex, theShort);
    }

    @Override
    public void setString(int parameterIndex, String theString) throws SQLException {
        this.bindNullOrString(parameterIndex, theString);
    }

    @Override
    public void setTime(int parameterIndex, Time theTime) throws SQLException {
        if (theTime == null) {
            this.bindNullOrString(parameterIndex, null);
        } else {
            this.bindLong(parameterIndex, theTime.getTime());
        }
    }

    @Override
    public void setTime(int parameterIndex, Time theTime, Calendar cal) throws SQLException {
        if (theTime == null) {
            this.bindNullOrString(parameterIndex, null);
        } else {
            this.bindLong(parameterIndex, theTime.getTime());
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp theTimestamp) throws SQLException {
        if (theTimestamp == null) {
            this.bindNullOrString(parameterIndex, null);
        } else {
            this.bindLong(parameterIndex, theTimestamp.getTime());
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp theTimestamp, Calendar cal) throws SQLException {
        if (theTimestamp == null) {
            this.bindNullOrString(parameterIndex, null);
        } else {
            this.bindLong(parameterIndex, theTimestamp.getTime());
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream theInputStream, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setURL(int parameterIndex, URL theURL) throws SQLException {
        this.bindNullOrString(parameterIndex, theURL);
    }

    @Override
    public void setRowId(int parameterIndex, RowId theRowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String theString) throws SQLException {
        this.bindNullOrString(parameterIndex, theString);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public String toString() {
        return this.sql;
    }
}

