/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android;

import android.database.Cursor;
import android.os.Handler;
import android.support.v7.widget.RecyclerView;
import io.requery.meta.EntityModel;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import io.requery.query.Result;
import io.requery.sql.ResultSetIterator;
import io.requery.util.function.Function;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class QueryRecyclerAdapter<E, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH>
implements Closeable {
    private final Handler handler;
    private final Function<E, EntityProxy<E>> proxyProvider;
    private ResultSetIterator<E> iterator;
    private boolean createdExecutor;
    private ExecutorService executor;
    private Future<Result<E>> queryFuture;

    protected QueryRecyclerAdapter(EntityModel model, Class<E> type) {
        this(model.typeOf(type));
    }

    protected QueryRecyclerAdapter(Type<E> type) {
        this.setHasStableIds(true);
        this.proxyProvider = type.proxyProvider();
        this.handler = new Handler();
    }

    @Override
    public void close() {
        if (this.queryFuture != null) {
            this.queryFuture.cancel(true);
        }
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
        this.setExecutor(null);
    }

    public void setExecutor(ExecutorService executor) {
        if (this.createdExecutor && this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = executor;
    }

    public void setResult(ResultSetIterator<E> iterator) {
        if (this.iterator != null) {
            this.iterator.close();
        }
        this.iterator = iterator;
        this.notifyDataSetChanged();
    }

    public void queryAsync() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
            this.createdExecutor = true;
        }
        if (this.queryFuture != null && !this.queryFuture.isDone()) {
            this.queryFuture.cancel(true);
        }
        this.queryFuture = this.executor.submit(new Callable<Result<E>>(){

            @Override
            public Result<E> call() {
                Result result = QueryRecyclerAdapter.this.performQuery();
                final ResultSetIterator iterator = (ResultSetIterator)result.iterator();
                QueryRecyclerAdapter.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        QueryRecyclerAdapter.this.setResult(iterator);
                    }
                });
                return result;
            }
        });
    }

    public abstract Result<E> performQuery();

    public void onBindViewHolder(VH holder, int position) {
        Object item = this.iterator.get(position);
        this.onBindViewHolder(item, holder, position);
    }

    public abstract void onBindViewHolder(E var1, VH var2, int var3);

    public long getItemId(int position) {
        Object item = this.iterator.get(position);
        if (item == null) {
            throw new IllegalStateException();
        }
        EntityProxy proxy = (EntityProxy)this.proxyProvider.apply(item);
        Object key = proxy.key();
        return key == null ? (long)item.hashCode() : (long)key.hashCode();
    }

    public int getItemCount() {
        if (this.iterator == null) {
            return 0;
        }
        try {
            Cursor cursor = (Cursor)this.iterator.unwrap(Cursor.class);
            return cursor.getCount();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.close();
        this.setExecutor(null);
    }
}

