/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlcipher;

import io.requery.android.sqlcipher.SqlCipherMetaData;
import io.requery.android.sqlcipher.SqlCipherPreparedStatement;
import io.requery.android.sqlcipher.SqlCipherStatement;
import io.requery.android.sqlite.BaseConnection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import net.sqlcipher.database.SQLiteConstraintException;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteException;

class SqlCipherConnection
extends BaseConnection {
    private final SQLiteDatabase db;
    private final SqlCipherMetaData metaData;
    private boolean enteredTransaction;

    SqlCipherConnection(SQLiteDatabase db) {
        if (db == null) {
            throw new IllegalArgumentException("null db");
        }
        this.db = db;
        this.autoCommit = true;
        this.metaData = new SqlCipherMetaData(this);
    }

    static void throwSQLException(SQLiteException exception) throws SQLException {
        if (exception instanceof SQLiteConstraintException) {
            throw new SQLIntegrityConstraintViolationException(exception);
        }
        throw new SQLException(exception);
    }

    SQLiteDatabase getDatabase() {
        return this.db;
    }

    @Override
    protected void ensureTransaction() {
        if (!this.autoCommit && !this.db.inTransaction()) {
            this.db.beginTransaction();
            this.enteredTransaction = true;
        }
    }

    @Override
    protected void execSQL(String sql) throws SQLException {
        try {
            this.db.execSQL(sql);
        }
        catch (SQLiteException e) {
            SqlCipherConnection.throwSQLException(e);
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.autoCommit) {
            throw new SQLException("commit called while in autoCommit mode");
        }
        if (this.db.inTransaction() && this.enteredTransaction) {
            try {
                this.db.setTransactionSuccessful();
            }
            catch (IllegalStateException e) {
                throw new SQLException(e);
            }
            finally {
                this.db.endTransaction();
                this.enteredTransaction = false;
            }
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.ensureTransaction();
        return new SqlCipherStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.ensureTransaction();
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetConcurrency == 1008) {
            throw new SQLFeatureNotSupportedException("CONCUR_UPDATABLE not supported");
        }
        this.ensureTransaction();
        return new SqlCipherStatement(this);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.db.isOpen();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.db.isReadOnly();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureTransaction();
        return new SqlCipherPreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureTransaction();
        return new SqlCipherPreparedStatement(this, sql, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.ensureTransaction();
        return new SqlCipherPreparedStatement(this, sql, 1);
    }

    @Override
    public void rollback() throws SQLException {
        if (this.autoCommit) {
            throw new SQLException("commit called while in autoCommit mode");
        }
        this.db.endTransaction();
    }
}

