/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlcipher;

import android.content.Context;
import android.database.Cursor;
import io.requery.android.DefaultMapping;
import io.requery.android.LoggingListener;
import io.requery.android.sqlcipher.SqlCipherConnection;
import io.requery.android.sqlite.DatabaseProvider;
import io.requery.android.sqlite.SchemaUpdater;
import io.requery.meta.EntityModel;
import io.requery.sql.Configuration;
import io.requery.sql.ConfigurationBuilder;
import io.requery.sql.ConnectionProvider;
import io.requery.sql.Mapping;
import io.requery.sql.Platform;
import io.requery.sql.SchemaModifier;
import io.requery.sql.StatementListener;
import io.requery.sql.TableCreationMode;
import io.requery.sql.platform.SQLite;
import io.requery.util.function.Function;
import java.sql.Connection;
import java.sql.SQLException;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteOpenHelper;

public class SqlCipherDatabaseSource
extends SQLiteOpenHelper
implements DatabaseProvider<SQLiteDatabase> {
    private final Platform platform;
    private final EntityModel model;
    private final Mapping mapping;
    private final String password;
    private SQLiteDatabase db;
    private Configuration configuration;
    private boolean loggingEnabled;
    private TableCreationMode mode;

    public SqlCipherDatabaseSource(Context context, EntityModel model, String name, String password, int version) {
        super(context, name, null, version);
        if (model == null) {
            throw new IllegalArgumentException("null model");
        }
        this.platform = new SQLite();
        this.mapping = this.onCreateMapping();
        this.model = model;
        this.password = password;
        this.mode = TableCreationMode.CREATE_NOT_EXISTS;
        SQLiteDatabase.loadLibs((Context)context);
    }

    @Override
    public void setLoggingEnabled(boolean enable) {
        this.loggingEnabled = enable;
    }

    @Override
    public void setTableCreationMode(TableCreationMode mode) {
        this.mode = mode;
    }

    protected Mapping onCreateMapping() {
        return new DefaultMapping(this.platform);
    }

    @Override
    protected void onConfigure(ConfigurationBuilder builder) {
        if (this.loggingEnabled) {
            LoggingListener loggingListener = new LoggingListener();
            builder.addStatementListener((StatementListener)loggingListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(SQLiteDatabase db) throws SQLException {
        SqlCipherDatabaseSource sqlCipherDatabaseSource = this;
        synchronized (sqlCipherDatabaseSource) {
            return new SqlCipherConnection(db);
        }
    }

    @Override
    public Configuration getConfiguration() {
        if (this.configuration == null) {
            ConfigurationBuilder builder = new ConfigurationBuilder((ConnectionProvider)this, this.model).setMapping(this.mapping).setPlatform(this.platform).setBatchUpdateSize(1000);
            this.onConfigure(builder);
            this.configuration = builder.build();
        }
        return this.configuration;
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        this.db = db;
        new SchemaModifier(this.getConfiguration()).createTables(TableCreationMode.CREATE);
    }

    @Override
    public void onConfigure(SQLiteDatabase db) {
    }

    @Override
    public void onUpgrade(final SQLiteDatabase db, int oldVersion, int newVersion) {
        this.db = db;
        SchemaUpdater updater = new SchemaUpdater(this.getConfiguration(), new Function<String, Cursor>(){

            public Cursor apply(String s) {
                return db.rawQuery(s, null);
            }
        }, this.mode);
        updater.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        SqlCipherDatabaseSource sqlCipherDatabaseSource = this;
        synchronized (sqlCipherDatabaseSource) {
            if (this.db == null) {
                this.db = this.getWritableDatabase(this.password);
            }
            return this.getConnection(this.db);
        }
    }

    @Override
    public SQLiteDatabase getReadableDatabase() {
        return this.getReadableDatabase(this.password);
    }

    @Override
    public SQLiteDatabase getWritableDatabase() {
        return this.getWritableDatabase(this.password);
    }
}

