/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlite;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.requery.android.DefaultMapping;
import io.requery.android.LoggingListener;
import io.requery.android.sqlite.DatabaseProvider;
import io.requery.android.sqlite.SchemaUpdater;
import io.requery.android.sqlite.SqliteConnection;
import io.requery.meta.EntityModel;
import io.requery.sql.Configuration;
import io.requery.sql.ConfigurationBuilder;
import io.requery.sql.ConnectionProvider;
import io.requery.sql.Mapping;
import io.requery.sql.Platform;
import io.requery.sql.SchemaModifier;
import io.requery.sql.StatementListener;
import io.requery.sql.TableCreationMode;
import io.requery.sql.platform.SQLite;
import io.requery.util.function.Function;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;

public class DatabaseSource
extends SQLiteOpenHelper
implements DatabaseProvider<SQLiteDatabase> {
    private final Platform platform;
    private final EntityModel model;
    private final Mapping mapping;
    private SQLiteDatabase db;
    private Configuration configuration;
    private boolean configured;
    private boolean loggingEnabled;
    private TableCreationMode mode;

    public DatabaseSource(Context context, EntityModel model, int version) {
        this(context, model, DatabaseSource.getDefaultDatabaseName(context, model), null, version);
    }

    public DatabaseSource(Context context, EntityModel model, @Nullable String name, int version) {
        this(context, model, name, null, version);
    }

    public DatabaseSource(Context context, EntityModel model, @Nullable String name, @Nullable SQLiteDatabase.CursorFactory factory, int version) {
        this(context, model, name, factory, version, new SQLite());
    }

    public DatabaseSource(Context context, EntityModel model, @Nullable String name, @Nullable SQLiteDatabase.CursorFactory factory, int version, SQLite platform) {
        super(context, name, factory, version);
        if (model == null) {
            throw new IllegalArgumentException("null model");
        }
        this.platform = platform;
        this.mapping = this.onCreateMapping((Platform)platform);
        this.model = model;
        this.mode = TableCreationMode.CREATE_NOT_EXISTS;
    }

    @Override
    public void setLoggingEnabled(boolean enable) {
        this.loggingEnabled = enable;
    }

    @Override
    public void setTableCreationMode(TableCreationMode mode) {
        this.mode = mode;
    }

    private static String getDefaultDatabaseName(Context context, EntityModel model) {
        return TextUtils.isEmpty((CharSequence)model.name()) ? context.getPackageName() : model.name();
    }

    protected Mapping onCreateMapping(Platform platform) {
        return new DefaultMapping(platform);
    }

    @Override
    protected void onConfigure(ConfigurationBuilder builder) {
        if (this.loggingEnabled) {
            LoggingListener loggingListener = new LoggingListener();
            builder.addStatementListener((StatementListener)loggingListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(SQLiteDatabase db) throws SQLException {
        DatabaseSource databaseSource = this;
        synchronized (databaseSource) {
            if (!db.isOpen()) {
                throw new SQLNonTransientConnectionException();
            }
            return new SqliteConnection(db);
        }
    }

    @Override
    public Configuration getConfiguration() {
        if (this.configuration == null) {
            ConfigurationBuilder builder = new ConfigurationBuilder((ConnectionProvider)this, this.model).setMapping(this.mapping).setPlatform(this.platform).setBatchUpdateSize(1000);
            this.onConfigure(builder);
            this.configuration = builder.build();
        }
        return this.configuration;
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        this.db = db;
        new SchemaModifier(this.getConfiguration()).createTables(TableCreationMode.CREATE);
    }

    @Override
    @TargetApi(value=16)
    public void onConfigure(SQLiteDatabase db) {
        super.onConfigure(db);
        if (!db.isReadOnly()) {
            db.setForeignKeyConstraintsEnabled(true);
        }
    }

    @Override
    public void onUpgrade(final SQLiteDatabase db, int oldVersion, int newVersion) {
        this.db = db;
        SchemaUpdater updater = new SchemaUpdater(this.getConfiguration(), new Function<String, Cursor>(){

            public Cursor apply(String s) {
                return db.rawQuery(s, null);
            }
        }, this.mode);
        updater.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        DatabaseSource databaseSource = this;
        synchronized (databaseSource) {
            if (this.db == null) {
                this.db = this.getWritableDatabase();
            }
            if (!this.configured && Build.VERSION.SDK_INT < 16) {
                this.db.execSQL("PRAGMA foreign_keys = ON");
                long pageSize = this.db.getPageSize();
                if (pageSize == 1024L) {
                    this.db.setPageSize(4096L);
                }
                this.configured = true;
            }
            return this.getConnection(this.db);
        }
    }
}

