/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlitex;

import android.database.SQLException;
import android.database.sqlite.SQLiteException;
import io.requery.android.database.sqlite.SQLiteDatabase;
import io.requery.android.sqlite.BaseConnection;
import io.requery.android.sqlitex.SqlitexMetaData;
import io.requery.android.sqlitex.SqlitexPreparedStatement;
import io.requery.android.sqlitex.SqlitexStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;

class SqlitexConnection
extends BaseConnection {
    private final SQLiteDatabase db;
    private final SqlitexMetaData metaData;
    private boolean enteredTransaction;

    SqlitexConnection(SQLiteDatabase db) {
        this.db = db;
        this.autoCommit = true;
        this.metaData = new SqlitexMetaData(this);
    }

    SQLiteDatabase getDatabase() {
        return this.db;
    }

    @Override
    protected void ensureTransaction() {
        if (!this.autoCommit && !this.db.inTransaction()) {
            this.db.beginTransaction();
            this.enteredTransaction = true;
        }
    }

    @Override
    protected void execSQL(String sql) throws java.sql.SQLException {
        try {
            this.db.execSQL(sql);
        }
        catch (SQLiteException e) {
            SqlitexConnection.throwSQLException((SQLException)((Object)e));
        }
    }

    @Override
    public void commit() throws java.sql.SQLException {
        if (this.autoCommit) {
            throw new java.sql.SQLException("commit called while in autoCommit mode");
        }
        if (this.db.inTransaction() && this.enteredTransaction) {
            try {
                this.db.setTransactionSuccessful();
            }
            catch (IllegalStateException e) {
                throw new java.sql.SQLException(e);
            }
            finally {
                this.db.endTransaction();
                this.enteredTransaction = false;
            }
        }
    }

    @Override
    public Statement createStatement() throws java.sql.SQLException {
        this.ensureTransaction();
        return new SqlitexStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws java.sql.SQLException {
        this.ensureTransaction();
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws java.sql.SQLException {
        if (resultSetConcurrency == 1008) {
            throw new SQLFeatureNotSupportedException("CONCUR_UPDATABLE not supported");
        }
        this.ensureTransaction();
        return new SqlitexStatement(this);
    }

    @Override
    public DatabaseMetaData getMetaData() throws java.sql.SQLException {
        return this.metaData;
    }

    @Override
    public boolean isClosed() throws java.sql.SQLException {
        return !this.db.isOpen();
    }

    @Override
    public boolean isReadOnly() throws java.sql.SQLException {
        return this.db.isReadOnly();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws java.sql.SQLException {
        this.ensureTransaction();
        return new SqlitexPreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws java.sql.SQLException {
        this.ensureTransaction();
        return new SqlitexPreparedStatement(this, sql, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws java.sql.SQLException {
        this.ensureTransaction();
        return new SqlitexPreparedStatement(this, sql, 1);
    }

    @Override
    public void rollback() throws java.sql.SQLException {
        if (this.autoCommit) {
            throw new java.sql.SQLException("commit called while in autoCommit mode");
        }
        this.db.endTransaction();
    }
}

