/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlcipher;

import android.database.Cursor;
import io.requery.android.sqlcipher.SqlCipherConnection;
import io.requery.android.sqlite.BasePreparedStatement;
import io.requery.android.sqlite.CursorResultSet;
import io.requery.android.sqlite.SingleResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sqlcipher.database.SQLiteException;
import net.sqlcipher.database.SQLiteStatement;

class SqlCipherPreparedStatement
extends BasePreparedStatement {
    private final SqlCipherConnection connection;
    private final SQLiteStatement statement;
    private Cursor cursor;

    SqlCipherPreparedStatement(SqlCipherConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        super(connection, sql, autoGeneratedKeys);
        this.connection = connection;
        this.statement = connection.getDatabase().compileStatement(sql);
    }

    @Override
    protected void bindNullOrString(int index, Object value) {
        if (value == null) {
            this.statement.bindNull(index);
            if (this.bindings != null) {
                this.bindings.add(null);
            }
        } else {
            String string = value.toString();
            this.statement.bindString(index, string);
            if (this.bindings != null) {
                this.bindings.add(string);
            }
        }
    }

    @Override
    protected void bindLong(int index, long value) {
        this.statement.bindLong(index, value);
        if (this.bindings != null) {
            this.bindings.add(value);
        }
    }

    @Override
    protected void bindDouble(int index, double value) {
        this.statement.bindDouble(index, value);
        if (this.bindings != null) {
            this.bindings.add(value);
        }
    }

    @Override
    protected void bindBlob(int index, byte[] value) {
        if (value == null) {
            this.statement.bindNull(index);
            if (this.bindings != null) {
                this.bindings.add(null);
            }
        } else {
            this.statement.bindBlob(index, value);
            if (this.bindings != null) {
                this.bindings.add("x'" + SqlCipherPreparedStatement.byteToHexString(value) + "'");
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.clearParameters();
        this.statement.close();
        if (this.cursor != null) {
            this.cursor.close();
        }
        super.close();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.statement.clearBindings();
        if (this.bindings != null) {
            this.bindings.clear();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.throwIfClosed();
        try {
            this.statement.execute();
        }
        catch (SQLiteException e) {
            SqlCipherConnection.throwSQLException(e);
        }
        return false;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.throwIfClosed();
        try {
            String[] args = this.bindingsToArray();
            this.cursor = this.connection.getDatabase().rawQuery(this.sql, args);
            this.queryResult = new CursorResultSet(this, this.cursor, false);
            return this.queryResult;
        }
        catch (SQLiteException e) {
            SqlCipherConnection.throwSQLException(e);
            return null;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.throwIfClosed();
        if (this.autoGeneratedKeys == 1) {
            try {
                long rowId = this.statement.executeInsert();
                if (rowId == -1L) {
                    throw new SQLException("executeInsert failed");
                }
                this.insertResult = new SingleResultSet(this, rowId);
            }
            catch (SQLiteException e) {
                SqlCipherConnection.throwSQLException(e);
            }
            return 1;
        }
        try {
            this.updateCount = this.statement.executeUpdateDelete();
            return this.updateCount;
        }
        catch (SQLiteException e) {
            SqlCipherConnection.throwSQLException(e);
            return 0;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == SQLiteStatement.class) {
            return iface.cast(this.statement);
        }
        return super.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface == SQLiteStatement.class || super.isWrapperFor(iface);
    }
}

