/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlite;

import android.database.Cursor;
import io.requery.meta.Attribute;
import io.requery.meta.Type;
import io.requery.sql.Configuration;
import io.requery.sql.SchemaModifier;
import io.requery.sql.TableCreationMode;
import io.requery.util.function.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;

public class SchemaUpdater {
    private final Configuration configuration;
    private final Function<String, Cursor> queryFunction;

    public SchemaUpdater(Configuration configuration, Function<String, Cursor> queryFunction) {
        this.configuration = configuration;
        this.queryFunction = queryFunction;
    }

    public void update() {
        SchemaModifier schema = new SchemaModifier(this.configuration);
        schema.createTables(TableCreationMode.CREATE_NOT_EXISTS);
        ArrayList missingAttributes = new ArrayList();
        for (Type type : this.configuration.entityModel().allTypes()) {
            String tableName = type.name();
            Cursor cursor = (Cursor)this.queryFunction.apply((Object)("PRAGMA table_info(" + tableName + ")"));
            LinkedHashMap<String, Attribute> map = new LinkedHashMap<String, Attribute>();
            for (Attribute attribute : type.attributes()) {
                if (attribute.isAssociation() && !attribute.isForeignKey()) continue;
                map.put(attribute.name(), attribute);
            }
            if (cursor.getCount() > 0) {
                int nameIndex = cursor.getColumnIndex("name");
                while (cursor.moveToNext()) {
                    String name = cursor.getString(nameIndex);
                    map.remove(name);
                }
            }
            cursor.close();
            missingAttributes.addAll(map.values());
        }
        Collections.sort(missingAttributes, new Comparator<Attribute>(){

            @Override
            public int compare(Attribute lhs, Attribute rhs) {
                if (lhs.isForeignKey() && rhs.isForeignKey()) {
                    return 0;
                }
                if (lhs.isForeignKey()) {
                    return 1;
                }
                return -1;
            }
        });
        for (Attribute attribute : missingAttributes) {
            schema.addColumn(attribute);
        }
    }
}

