/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlite;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteStatement;
import io.requery.android.sqlite.BasePreparedStatement;
import io.requery.android.sqlite.CursorResultSet;
import io.requery.android.sqlite.SingleResultSet;
import io.requery.android.sqlite.SqliteConnection;
import java.sql.ResultSet;

class SqlitePreparedStatement
extends BasePreparedStatement {
    private final SqliteConnection connection;
    private final SQLiteStatement statement;
    private SQLiteCursor cursor;

    SqlitePreparedStatement(SqliteConnection connection, String sql, int autoGeneratedKeys) throws java.sql.SQLException {
        super(connection, sql, autoGeneratedKeys);
        this.connection = connection;
        this.statement = connection.getDatabase().compileStatement(sql);
    }

    @Override
    protected void bindNullOrString(int index, Object value) {
        if (value == null) {
            this.statement.bindNull(index);
            if (this.bindings != null) {
                this.bindings.add(null);
            }
        } else {
            String string = value.toString();
            this.statement.bindString(index, string);
            if (this.bindings != null) {
                this.bindings.add(string);
            }
        }
    }

    @Override
    protected void bindLong(int index, long value) {
        this.statement.bindLong(index, value);
        if (this.bindings != null) {
            this.bindings.add(value);
        }
    }

    @Override
    protected void bindDouble(int index, double value) {
        this.statement.bindDouble(index, value);
        if (this.bindings != null) {
            this.bindings.add(value);
        }
    }

    @Override
    protected void bindBlob(int index, byte[] value) {
        if (value == null) {
            this.statement.bindNull(index);
            if (this.bindings != null) {
                this.bindings.add(null);
            }
        } else {
            this.statement.bindBlob(index, value);
            if (this.bindings != null) {
                this.bindings.add("x'" + SqlitePreparedStatement.byteToHexString(value) + "'");
            }
        }
    }

    @Override
    public void close() throws java.sql.SQLException {
        this.clearParameters();
        this.statement.close();
        if (this.cursor != null) {
            this.cursor.close();
        }
        super.close();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws java.sql.SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet executeQuery(String sql) throws java.sql.SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws java.sql.SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearParameters() throws java.sql.SQLException {
        this.throwIfClosed();
        this.statement.clearBindings();
        if (this.bindings != null) {
            this.bindings.clear();
        }
    }

    @Override
    public boolean execute() throws java.sql.SQLException {
        this.throwIfClosed();
        try {
            this.statement.execute();
        }
        catch (SQLException e) {
            SqliteConnection.throwSQLException(e);
        }
        return false;
    }

    @Override
    public ResultSet executeQuery() throws java.sql.SQLException {
        this.throwIfClosed();
        try {
            String[] args = this.bindingsToArray();
            if (this.cursor != null) {
                this.cursor.setSelectionArguments(args);
                if (!this.cursor.requery()) {
                    this.cursor.close();
                    this.cursor = null;
                }
            }
            if (this.cursor == null) {
                this.cursor = (SQLiteCursor)this.connection.getDatabase().rawQuery(this.sql, args);
            }
            this.queryResult = new CursorResultSet(this, (Cursor)this.cursor, false);
            return this.queryResult;
        }
        catch (SQLException e) {
            SqliteConnection.throwSQLException(e);
            return null;
        }
    }

    @Override
    public int executeUpdate() throws java.sql.SQLException {
        this.throwIfClosed();
        if (this.autoGeneratedKeys == 1) {
            try {
                long rowId = this.statement.executeInsert();
                this.insertResult = new SingleResultSet(this, rowId);
            }
            catch (SQLException e) {
                SqliteConnection.throwSQLException(e);
            }
            return 1;
        }
        try {
            this.updateCount = this.statement.executeUpdateDelete();
            return this.updateCount;
        }
        catch (SQLException e) {
            SqliteConnection.throwSQLException(e);
            return 0;
        }
    }
}

