/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlite;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

class ByteArrayBlob
implements Blob {
    private byte[] blob;
    private boolean freed;

    ByteArrayBlob(byte[] blob) {
        this.blob = blob;
    }

    private void throwIfFreed() throws SQLException {
        if (this.freed) {
            throw new SQLException("blob freed");
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.throwIfFreed();
        return new ByteArrayInputStream(this.blob);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (pos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("invalid position");
        }
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("invalid position");
        }
        this.throwIfFreed();
        return new ByteArrayInputStream(this.blob, (int)pos, (int)length);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("invalid position");
        }
        if (pos == 0L && length == this.blob.length) {
            return this.blob;
        }
        this.throwIfFreed();
        byte[] bytes = new byte[length];
        System.arraycopy(this.blob, (int)pos, bytes, 0, length);
        return bytes;
    }

    @Override
    public long length() throws SQLException {
        this.throwIfFreed();
        return this.blob.length;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long pos, byte[] theBytes) throws SQLException {
        if (pos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("invalid position");
        }
        this.throwIfFreed();
        System.arraycopy(theBytes, 0, this.blob, (int)pos, theBytes.length);
        return theBytes.length;
    }

    @Override
    public int setBytes(long pos, byte[] theBytes, int offset, int len) throws SQLException {
        if (pos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("invalid position");
        }
        this.throwIfFreed();
        System.arraycopy(theBytes, offset, this.blob, (int)pos, len);
        return len;
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.throwIfFreed();
        byte[] truncated = new byte[(int)len];
        System.arraycopy(this.blob, 0, truncated, 0, truncated.length);
        this.blob = truncated;
    }

    @Override
    public void free() throws SQLException {
        this.blob = null;
        this.freed = true;
    }
}

