/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android;

import android.os.Parcel;
import io.requery.meta.Attribute;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import io.requery.proxy.PropertyState;

public class EntityParceler<T> {
    private final Type<T> type;

    public EntityParceler(Type<T> type) {
        this.type = type;
    }

    public T readFromParcel(Parcel in) {
        Object entity = this.type.factory().get();
        EntityProxy proxy = (EntityProxy)this.type.proxyProvider().apply(entity);
        for (Attribute attribute : this.type.attributes()) {
            Object value;
            if (attribute.isAssociation()) continue;
            Class typeClass = attribute.classType();
            if (typeClass.isEnum()) {
                String name = (String)in.readValue(null);
                if (name == null) {
                    value = null;
                } else {
                    Class enumClass = typeClass;
                    value = Enum.valueOf(enumClass, name);
                }
            } else {
                value = in.readValue(null);
            }
            PropertyState state = PropertyState.LOADED;
            if (!this.type.isStateless()) {
                state = PropertyState.valueOf((String)in.readValue(null).toString());
            }
            proxy.setObject(attribute, value, state);
        }
        return (T)entity;
    }

    public void writeToParcel(T entity, Parcel out) {
        EntityProxy proxy = (EntityProxy)this.type.proxyProvider().apply(entity);
        for (Attribute attribute : this.type.attributes()) {
            Object value = proxy.get(attribute, false);
            Class typeClass = attribute.classType();
            if (typeClass.isEnum() && value != null) {
                value = value.toString();
            }
            out.writeValue(value);
            if (this.type.isStateless()) continue;
            PropertyState state = proxy.getState(attribute);
            out.writeString(state.toString());
        }
    }
}

