/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlite;

import io.requery.android.sqlite.BaseConnection;
import io.requery.android.sqlite.BaseStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public abstract class BasePreparedStatement
extends BaseStatement
implements PreparedStatement {
    private static final char[] hex = "0123456789ABCDEF".toCharArray();
    protected String sql;
    protected final int autoGeneratedKeys;
    protected List<Object> bindings;

    protected BasePreparedStatement(BaseConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        super(connection);
        if (sql == null) {
            throw new SQLException("null sql");
        }
        if (autoGeneratedKeys != 1) {
            this.bindings = new ArrayList<Object>(4);
        }
        this.sql = sql;
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    protected abstract void bindNullOrString(int var1, Object var2);

    protected abstract void bindLong(int var1, long var2);

    protected abstract void bindDouble(int var1, double var2);

    protected abstract void bindBlob(int var1, byte[] var2);

    protected String[] bindingsToArray() {
        String[] args = new String[this.bindings.size()];
        for (int i = 0; i < this.bindings.size(); ++i) {
            Object value = this.bindings.get(i);
            if (value == null) continue;
            args[i] = value.toString();
        }
        return args;
    }

    protected static String byteToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(hex[b >> 4 & 0xF]);
            sb.append(hex[b & 0xF]);
        }
        return sb.toString();
    }

    protected void bindBlobLiteral(int index, byte[] value) {
        int placeHolderIndex = 0;
        int replace = 0;
        for (int i = 0; i < this.sql.length(); ++i) {
            if (this.sql.charAt(i) != '?' || ++placeHolderIndex != index) continue;
            replace = i;
            break;
        }
        String literal = "x'" + BasePreparedStatement.byteToHexString(value) + "'";
        this.sql = this.sql.substring(0, replace) + literal + this.sql.substring(replace + 1, this.sql.length() - 1);
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.bindNullOrString(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setBytes(parameterIndex, x.getBytes(0L, (int)x.length()));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        long value = x ? 1L : 0L;
        this.bindLong(parameterIndex, value);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.bindLong(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.bindBlob(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (x == null) {
            this.bindNullOrString(parameterIndex, null);
        } else {
            this.bindLong(parameterIndex, x.getTime());
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.bindDouble(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.bindDouble(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.bindLong(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.bindLong(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.bindNullOrString(parameterIndex, null);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.bindNullOrString(paramIndex, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else if (x instanceof String) {
            this.setString(parameterIndex, x.toString());
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Boolean) {
            this.setLong(parameterIndex, (Boolean)x != false ? 1L : 0L);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)x;
            this.setDate(parameterIndex, new Date(date.getTime()));
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else {
            throw new SQLException("unhandled type " + x.getClass().getCanonicalName());
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (x == null || targetSqlType == 0) {
            this.setNull(parameterIndex, 0);
            return;
        }
        switch (targetSqlType) {
            case 4: 
            case 5: {
                if (x instanceof Integer) {
                    this.bindLong(parameterIndex, ((Integer)x).longValue());
                    break;
                }
                if (x instanceof Long) {
                    this.bindLong(parameterIndex, (Long)x);
                    break;
                }
                if (!(x instanceof Short)) break;
                this.bindLong(parameterIndex, ((Short)x).longValue());
                break;
            }
            case -6: {
                if (!(x instanceof Byte)) break;
                this.bindLong(parameterIndex, ((Byte)x).longValue());
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (x instanceof Double) {
                    this.setDouble(parameterIndex, (Double)x);
                    break;
                }
                if (!(x instanceof Float)) break;
                this.setFloat(parameterIndex, ((Float)x).floatValue());
                break;
            }
            case 3: {
                if (!(x instanceof BigDecimal)) break;
                this.setBigDecimal(parameterIndex, (BigDecimal)x);
                break;
            }
            case -3: 
            case -2: 
            case 2004: {
                this.setBytes(parameterIndex, (byte[])x);
                break;
            }
            case 16: {
                Boolean value = (Boolean)x;
                this.setBoolean(parameterIndex, value);
                break;
            }
            case -9: 
            case 12: {
                String string = x instanceof String ? (String)x : x.toString();
                this.setString(parameterIndex, string);
                break;
            }
            case 91: {
                if (x instanceof Date) {
                    Date date = (Date)x;
                    this.setLong(parameterIndex, date.getTime());
                    break;
                }
                if (!(x instanceof java.util.Date)) break;
                java.util.Date date = (java.util.Date)x;
                this.setLong(parameterIndex, date.getTime());
                break;
            }
            case 93: {
                if (!(x instanceof Timestamp)) break;
                Timestamp timestamp = (Timestamp)x;
                this.setLong(parameterIndex, timestamp.getTime());
                break;
            }
            case -5: {
                if (!(x instanceof BigInteger)) break;
                BigInteger bigInteger = (BigInteger)x;
                this.bindNullOrString(parameterIndex, bigInteger.toString());
                break;
            }
            default: {
                throw new SQLException("unhandled type " + targetSqlType);
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.bindLong(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.bindNullOrString(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (x == null) {
            this.bindNullOrString(parameterIndex, null);
        } else {
            this.bindLong(parameterIndex, x.getTime());
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (x == null) {
            this.bindNullOrString(parameterIndex, null);
        } else {
            this.bindLong(parameterIndex, x.getTime());
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (x == null) {
            this.bindNullOrString(parameterIndex, null);
        } else {
            this.bindLong(parameterIndex, x.getTime());
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (x == null) {
            this.bindNullOrString(parameterIndex, null);
        } else {
            this.bindLong(parameterIndex, x.getTime());
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.bindNullOrString(parameterIndex, x);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        this.bindNullOrString(parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public String toString() {
        return this.sql;
    }
}

