/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlitex;

import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import io.requery.android.DefaultMapping;
import io.requery.android.LoggingListener;
import io.requery.android.database.sqlite.SQLiteDatabase;
import io.requery.android.database.sqlite.SQLiteOpenHelper;
import io.requery.android.sqlite.DatabaseProvider;
import io.requery.android.sqlite.SchemaUpdater;
import io.requery.android.sqlitex.SqlitexConnection;
import io.requery.meta.EntityModel;
import io.requery.sql.Configuration;
import io.requery.sql.ConfigurationBuilder;
import io.requery.sql.ConnectionProvider;
import io.requery.sql.Mapping;
import io.requery.sql.Platform;
import io.requery.sql.SchemaModifier;
import io.requery.sql.StatementListener;
import io.requery.sql.TableCreationMode;
import io.requery.sql.platform.SQLite;
import io.requery.util.function.Function;
import java.sql.Connection;
import java.sql.SQLException;

public class SqlitexDatabaseSource
extends SQLiteOpenHelper
implements DatabaseProvider<SQLiteDatabase> {
    private final Platform platform;
    private final EntityModel model;
    private Mapping mapping;
    private SQLiteDatabase db;
    private Configuration configuration;
    private boolean loggingEnabled;
    private TableCreationMode mode;

    public SqlitexDatabaseSource(Context context, EntityModel model, int version) {
        this(context, model, SqlitexDatabaseSource.getDefaultDatabaseName(context, model), version);
    }

    public SqlitexDatabaseSource(Context context, EntityModel model, String name, int version) {
        super(context, name, null, version);
        if (model == null) {
            throw new IllegalArgumentException("null model");
        }
        this.platform = new SQLite();
        this.model = model;
        this.mode = TableCreationMode.CREATE_NOT_EXISTS;
    }

    private static String getDefaultDatabaseName(Context context, EntityModel model) {
        return TextUtils.isEmpty((CharSequence)model.getName()) ? context.getPackageName() : model.getName();
    }

    @Override
    public void setLoggingEnabled(boolean enable) {
        this.loggingEnabled = enable;
    }

    @Override
    public void setTableCreationMode(TableCreationMode mode) {
        this.mode = mode;
    }

    protected Mapping onCreateMapping(Platform platform) {
        return new DefaultMapping(platform);
    }

    @Override
    protected void onConfigure(ConfigurationBuilder builder) {
        if (this.loggingEnabled) {
            LoggingListener loggingListener = new LoggingListener();
            builder.addStatementListener((StatementListener)loggingListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(SQLiteDatabase db) throws SQLException {
        SqlitexDatabaseSource sqlitexDatabaseSource = this;
        synchronized (sqlitexDatabaseSource) {
            return new SqlitexConnection(db);
        }
    }

    @Override
    public Configuration getConfiguration() {
        if (this.mapping == null) {
            this.mapping = this.onCreateMapping(this.platform);
        }
        if (this.mapping == null) {
            throw new IllegalStateException();
        }
        if (this.configuration == null) {
            ConfigurationBuilder builder = new ConfigurationBuilder((ConnectionProvider)this, this.model).setMapping(this.mapping).setPlatform(this.platform).setBatchUpdateSize(1000);
            this.onConfigure(builder);
            this.configuration = builder.build();
        }
        return this.configuration;
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        this.db = db;
        new SchemaModifier(this.getConfiguration()).createTables(TableCreationMode.CREATE);
    }

    @Override
    public void onUpgrade(final SQLiteDatabase db, int oldVersion, int newVersion) {
        this.db = db;
        SchemaUpdater updater = new SchemaUpdater(this.getConfiguration(), new Function<String, Cursor>(){

            public Cursor apply(String s) {
                return db.rawQuery(s, null);
            }
        }, this.mode);
        updater.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        SqlitexDatabaseSource sqlitexDatabaseSource = this;
        synchronized (sqlitexDatabaseSource) {
            if (this.db == null) {
                this.db = this.getWritableDatabase();
            }
            return this.getConnection(this.db);
        }
    }
}

