/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android;

import android.os.Parcel;
import android.os.Parcelable;
import io.requery.Converter;

public class ParcelConverter<T extends Parcelable>
implements Converter<T, byte[]> {
    private final Class<T> type;
    private final Parcelable.Creator<T> creator;

    public ParcelConverter(Class<T> type, Parcelable.Creator<T> creator) {
        if (type == null || creator == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.creator = creator;
    }

    public Class<T> getMappedType() {
        return this.type;
    }

    public Class<byte[]> getPersistedType() {
        return byte[].class;
    }

    public Integer getPersistedSize() {
        return null;
    }

    public byte[] convertToPersisted(T value) {
        if (value != null) {
            Parcel parcel = Parcel.obtain();
            value.writeToParcel(parcel, 0);
            return parcel.marshall();
        }
        return null;
    }

    public T convertToMapped(Class<? extends T> type, byte[] value) {
        if (value == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(value, 0, value.length);
        return (T)((Parcelable)this.creator.createFromParcel(parcel));
    }
}

