/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android;

import android.database.Cursor;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import io.requery.meta.EntityModel;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import io.requery.query.Result;
import io.requery.sql.ResultSetIterator;
import io.requery.util.function.Function;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class QueryAdapter<E>
extends BaseAdapter
implements Closeable {
    private final Handler handler;
    private final Function<E, EntityProxy<E>> proxyProvider;
    private ResultSetIterator<E> iterator;
    private boolean createdExecutor;
    private ExecutorService executor;
    private Future<Result<E>> queryFuture;

    protected QueryAdapter(EntityModel model, Class<E> type) {
        this(model.typeOf(type));
    }

    protected QueryAdapter() {
        this(null);
    }

    protected QueryAdapter(Type<E> type) {
        this.proxyProvider = type == null ? null : type.getProxyProvider();
        this.handler = new Handler();
    }

    @Override
    public void close() {
        if (this.queryFuture != null) {
            this.queryFuture.cancel(true);
        }
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
    }

    public void setExecutor(ExecutorService executor) {
        if (this.createdExecutor && this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = executor;
    }

    public void setResult(ResultSetIterator<E> iterator) {
        this.close();
        this.iterator = iterator;
        this.notifyDataSetChanged();
    }

    public void queryAsync() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
            this.createdExecutor = true;
        }
        if (this.queryFuture != null && !this.queryFuture.isDone()) {
            this.queryFuture.cancel(true);
        }
        this.queryFuture = this.executor.submit(new Callable<Result<E>>(){

            @Override
            public Result<E> call() {
                final Result result = QueryAdapter.this.performQuery();
                QueryAdapter.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        QueryAdapter.this.setResult((ResultSetIterator)result.iterator());
                    }
                });
                return result;
            }
        });
    }

    public abstract Result<E> performQuery();

    public E getItem(int position) {
        if (this.iterator == null) {
            return null;
        }
        return (E)this.iterator.get(position);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        E item = this.getItem(position);
        return this.getView(item, convertView, parent);
    }

    public abstract View getView(E var1, View var2, ViewGroup var3);

    public long getItemId(int position) {
        Object item = this.iterator.get(position);
        Object key = null;
        if (this.proxyProvider != null) {
            EntityProxy proxy = (EntityProxy)this.proxyProvider.apply(item);
            key = proxy.key();
        }
        return key == null ? (long)item.hashCode() : (long)key.hashCode();
    }

    public int getCount() {
        if (this.iterator == null) {
            return 0;
        }
        try {
            Cursor cursor = (Cursor)this.iterator.unwrap(Cursor.class);
            return cursor.getCount();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

