/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlite;

import android.database.Cursor;
import io.requery.android.sqlite.BasePreparedStatement;
import io.requery.android.sqlite.NonUpdateableResultSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Map;

public class CursorResultSet
extends NonUpdateableResultSet
implements ResultSetMetaData {
    private final Statement statement;
    private final Cursor cursor;
    private final boolean closeCursor;
    private int lastColumnIndex;

    public CursorResultSet(Statement statement, Cursor cursor, boolean closeCursor) {
        if (cursor == null) {
            throw new IllegalArgumentException("null cursor");
        }
        this.statement = statement;
        this.cursor = cursor;
        this.closeCursor = closeCursor;
        cursor.moveToPosition(-1);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.cursor.moveToPosition(row - 1);
    }

    @Override
    public void afterLast() throws SQLException {
        this.cursor.moveToLast();
        this.cursor.moveToNext();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.cursor.moveToPosition(-1);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        if (this.closeCursor) {
            this.cursor.close();
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        int index = this.cursor.getColumnIndex(columnName);
        if (index == -1) {
            throw new SQLDataException("no column " + columnName);
        }
        return index + 1;
    }

    @Override
    public boolean first() throws SQLException {
        return this.cursor.moveToFirst();
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        return value == null ? null : new BigDecimal(value);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal result;
        String value = this.getString(columnIndex);
        BigDecimal bigDecimal = result = value == null ? null : new BigDecimal(value);
        if (result != null) {
            result = result.setScale(scale, 1);
        }
        return result;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return new ByteArrayInputStream(this.getBytes(columnIndex));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getInt(columnIndex) > 0;
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return (byte)this.getShort(columnIndex);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.lastColumnIndex = columnIndex;
        return this.cursor.getBlob(columnIndex - 1);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return new StringReader(this.getString(columnIndex));
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return new StringReader(this.getString(columnName));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.lastColumnIndex = columnIndex;
        if (this.cursor.isNull(columnIndex - 1)) {
            return null;
        }
        if (this.cursor.getType(columnIndex - 1) == 1) {
            return new Date(this.cursor.getLong(columnIndex - 1));
        }
        try {
            String value = this.cursor.getString(columnIndex - 1);
            return new Date(BasePreparedStatement.ISO8601_FORMAT.parse(value).getTime());
        }
        catch (ParseException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.lastColumnIndex = columnIndex;
        return this.cursor.getDouble(columnIndex - 1);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.lastColumnIndex = columnIndex;
        return this.cursor.getFloat(columnIndex - 1);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.lastColumnIndex = columnIndex;
        return this.cursor.getInt(columnIndex - 1);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.lastColumnIndex = columnIndex;
        return this.cursor.getLong(columnIndex - 1);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.lastColumnIndex = columnIndex--;
        int type = this.cursor.getType(columnIndex);
        if (!this.cursor.isNull(columnIndex)) {
            switch (type) {
                case 4: {
                    return this.cursor.getBlob(columnIndex);
                }
                case 2: {
                    return Float.valueOf(this.cursor.getFloat(columnIndex));
                }
                case 1: {
                    return this.cursor.getInt(columnIndex);
                }
                case 0: {
                    return null;
                }
                case 3: {
                    return this.cursor.getString(columnIndex);
                }
            }
        }
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnName), map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    @Override
    public int getRow() throws SQLException {
        return this.cursor.getPosition() + 1;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.lastColumnIndex = columnIndex;
        return this.cursor.getShort(columnIndex - 1);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.lastColumnIndex = columnIndex;
        if (this.cursor.isNull(columnIndex - 1)) {
            return null;
        }
        return this.cursor.getString(columnIndex - 1);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.lastColumnIndex = columnIndex;
        if (this.cursor.isNull(columnIndex - 1)) {
            return null;
        }
        return new Time(this.getLong(columnIndex - 1));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.lastColumnIndex = columnIndex;
        if (this.cursor.isNull(columnIndex - 1)) {
            return null;
        }
        return new Time(this.getLong(columnIndex - 1));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.lastColumnIndex = columnIndex;
        if (this.cursor.isNull(columnIndex - 1)) {
            return null;
        }
        return new Timestamp(this.cursor.getLong(columnIndex - 1));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getType() throws SQLException {
        return 1005;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (value == null) {
            return null;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.cursor.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.cursor.getCount() != 0 && this.cursor.isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.cursor.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.cursor.isLast() || this.cursor.getCount() == 0;
    }

    @Override
    public boolean last() throws SQLException {
        return this.cursor.moveToLast();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
    }

    @Override
    public boolean next() throws SQLException {
        return this.cursor.moveToNext();
    }

    @Override
    public boolean previous() throws SQLException {
        return this.cursor.moveToPrevious();
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.cursor.move(rows);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLException("Only FETCH_FORWARD is supported");
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.cursor.isNull(this.lastColumnIndex - 1);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.cursor.isClosed();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == Cursor.class) {
            return iface.cast(this.cursor);
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface == Cursor.class;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return null;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.cursor.getColumnCount();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return "";
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.cursor.getColumnName(column - 1);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        int type = this.cursor.getType(column - 1);
        switch (type) {
            case 4: {
                return -3;
            }
            case 2: {
                return 6;
            }
            case 1: {
                return 4;
            }
            case 0: {
                return 0;
            }
            case 3: {
                return 12;
            }
        }
        return 0;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return null;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return null;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 2;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }
}

