/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android;

import android.util.Log;
import io.requery.proxy.PostDeleteListener;
import io.requery.proxy.PostInsertListener;
import io.requery.proxy.PostLoadListener;
import io.requery.proxy.PostUpdateListener;
import io.requery.proxy.PreDeleteListener;
import io.requery.proxy.PreInsertListener;
import io.requery.proxy.PreUpdateListener;
import io.requery.sql.BoundParameters;
import io.requery.sql.StatementListener;
import java.sql.Statement;

public class LoggingListener
implements StatementListener,
PostLoadListener<Object>,
PostInsertListener<Object>,
PostDeleteListener<Object>,
PostUpdateListener<Object>,
PreInsertListener<Object>,
PreDeleteListener<Object>,
PreUpdateListener<Object> {
    private final String tag;

    public LoggingListener() {
        this("requery");
    }

    public LoggingListener(String tag) {
        this.tag = tag;
    }

    public void postLoad(Object entity) {
        Log.i((String)this.tag, (String)String.format("postLoad %s", entity));
    }

    public void postInsert(Object entity) {
        Log.i((String)this.tag, (String)String.format("postInsert %s", entity));
    }

    public void postDelete(Object entity) {
        Log.i((String)this.tag, (String)String.format("postDelete %s", entity));
    }

    public void postUpdate(Object entity) {
        Log.i((String)this.tag, (String)String.format("postUpdate %s", entity));
    }

    public void preInsert(Object entity) {
        Log.i((String)this.tag, (String)String.format("preInsert %s", entity));
    }

    public void preDelete(Object entity) {
        Log.i((String)this.tag, (String)String.format("preDelete %s", entity));
    }

    public void preUpdate(Object entity) {
        Log.i((String)this.tag, (String)String.format("preUpdate %s", entity));
    }

    public void beforeExecuteUpdate(Statement statement, String sql, BoundParameters parameters) {
        Log.i((String)this.tag, (String)String.format("beforeExecuteUpdate sql: %s", sql));
    }

    public void afterExecuteUpdate(Statement statement, int count) {
        Log.i((String)this.tag, (String)String.format("afterExecuteUpdate %d", count));
    }

    public void beforeExecuteBatchUpdate(Statement statement, String sql) {
        Log.i((String)this.tag, (String)String.format("beforeExecuteUpdate sql: %s", sql));
    }

    public void afterExecuteBatchUpdate(Statement statement, int[] count) {
        Log.i((String)this.tag, (String)"afterExecuteBatchUpdate");
    }

    public void beforeExecuteQuery(Statement statement, String sql, BoundParameters parameters) {
        Log.i((String)this.tag, (String)String.format("beforeExecuteQuery sql: %s", sql));
    }

    public void afterExecuteQuery(Statement statement) {
        Log.i((String)this.tag, (String)"afterExecuteQuery");
    }
}

