/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlite;

import android.database.Cursor;
import android.database.CursorWrapper;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import io.requery.android.sqlite.BaseConnection;
import io.requery.android.sqlite.CursorResultSet;
import io.requery.sql.Keyword;
import io.requery.sql.QueryBuilder;
import io.requery.util.function.Function;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class SqliteMetaData
implements DatabaseMetaData {
    private final BaseConnection connection;

    protected SqliteMetaData(BaseConnection connection) {
        this.connection = connection;
    }

    protected <R> R queryMemory(Function<Cursor, R> function, String query) throws java.sql.SQLException {
        try {
            SQLiteDatabase database = SQLiteDatabase.openOrCreateDatabase((String)":memory:", null);
            Cursor cursor = database.rawQuery(query, null);
            return (R)function.apply((Object)this.closeWithCursor((Closeable)database, cursor));
        }
        catch (SQLException e) {
            throw new java.sql.SQLException(e);
        }
    }

    protected CursorWrapper closeWithCursor(final Closeable closeable, Cursor cursor) {
        return new CursorWrapper(cursor){

            public void close() {
                super.close();
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    @Override
    public boolean allProceduresAreCallable() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws java.sql.SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getCatalogs() throws java.sql.SQLException {
        return null;
    }

    @Override
    public String getCatalogSeparator() throws java.sql.SQLException {
        return null;
    }

    @Override
    public String getCatalogTerm() throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws java.sql.SQLException {
        return null;
    }

    @Override
    public Connection getConnection() throws java.sql.SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws java.sql.SQLException {
        return null;
    }

    @Override
    public int getDatabaseMajorVersion() throws java.sql.SQLException {
        return Integer.parseInt(this.getDatabaseProductVersion().split(".")[0]);
    }

    @Override
    public int getDatabaseMinorVersion() throws java.sql.SQLException {
        return Integer.parseInt(this.getDatabaseProductVersion().split(".")[1]);
    }

    @Override
    public String getDatabaseProductName() throws java.sql.SQLException {
        return "SQLite";
    }

    @Override
    public String getDatabaseProductVersion() throws java.sql.SQLException {
        return this.queryMemory(new Function<Cursor, String>(){

            public String apply(Cursor cursor) {
                String version = "";
                if (cursor.moveToNext()) {
                    version = cursor.getString(0);
                }
                return version;
            }
        }, "select sqlite_version() AS sqlite_version");
    }

    @Override
    public int getDefaultTransactionIsolation() throws java.sql.SQLException {
        return 2;
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDriverName() throws java.sql.SQLException {
        return "SQLite Android";
    }

    @Override
    public String getDriverVersion() throws java.sql.SQLException {
        return "1.0";
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws java.sql.SQLException {
        return null;
    }

    @Override
    public String getExtraNameCharacters() throws java.sql.SQLException {
        return "";
    }

    @Override
    public String getIdentifierQuoteString() throws java.sql.SQLException {
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws java.sql.SQLException {
        return null;
    }

    @Override
    public int getJDBCMajorVersion() throws java.sql.SQLException {
        return 1;
    }

    @Override
    public int getJDBCMinorVersion() throws java.sql.SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws java.sql.SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws java.sql.SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws java.sql.SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws java.sql.SQLException {
        return 1000000000;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws java.sql.SQLException {
        return 500;
    }

    @Override
    public int getMaxColumnsInIndex() throws java.sql.SQLException {
        return 500;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws java.sql.SQLException {
        return 500;
    }

    @Override
    public int getMaxColumnsInSelect() throws java.sql.SQLException {
        return 500;
    }

    @Override
    public int getMaxColumnsInTable() throws java.sql.SQLException {
        return 2000;
    }

    @Override
    public int getMaxConnections() throws java.sql.SQLException {
        return 1;
    }

    @Override
    public int getMaxCursorNameLength() throws java.sql.SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws java.sql.SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws java.sql.SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws java.sql.SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws java.sql.SQLException {
        return 1000000;
    }

    @Override
    public int getMaxStatementLength() throws java.sql.SQLException {
        return 1000000;
    }

    @Override
    public int getMaxStatements() throws java.sql.SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws java.sql.SQLException {
        return 1000000;
    }

    @Override
    public int getMaxTablesInSelect() throws java.sql.SQLException {
        return 500;
    }

    @Override
    public int getMaxUserNameLength() throws java.sql.SQLException {
        return 0;
    }

    @Override
    public String getNumericFunctions() throws java.sql.SQLException {
        return "abs,hex,max,min,random";
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws java.sql.SQLException {
        return null;
    }

    @Override
    public String getProcedureTerm() throws java.sql.SQLException {
        return null;
    }

    @Override
    public int getResultSetHoldability() throws java.sql.SQLException {
        return 1;
    }

    @Override
    public ResultSet getSchemas() throws java.sql.SQLException {
        return null;
    }

    @Override
    public String getSchemaTerm() throws java.sql.SQLException {
        return null;
    }

    @Override
    public String getSearchStringEscape() throws java.sql.SQLException {
        return null;
    }

    @Override
    public String getSQLKeywords() throws java.sql.SQLException {
        return "";
    }

    @Override
    public int getSQLStateType() throws java.sql.SQLException {
        return 2;
    }

    @Override
    public String getStringFunctions() throws java.sql.SQLException {
        return "";
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws java.sql.SQLException {
        return null;
    }

    @Override
    public String getSystemFunctions() throws java.sql.SQLException {
        return "";
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws java.sql.SQLException {
        if (types == null) {
            types = new String[]{"TABLE", "VIEW"};
        }
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        LinkedHashMap<String, String> select = new LinkedHashMap<String, String>();
        select.put("TABLE_CAT", null);
        select.put("TABLE_SCHEM", null);
        select.put("TABLE_NAME", "name");
        select.put("TABLE_TYPE", "type");
        select.put("REMARKS", null);
        select.put("TYPE_CAT", null);
        select.put("TYPE_SCHEM", null);
        select.put("TYPE_NAME", null);
        select.put("SELF_REFERENCING_COL_NAME", null);
        select.put("REF_GENERATION", null);
        QueryBuilder qb = new QueryBuilder(new QueryBuilder.Options(this.getIdentifierQuoteString(), true, null, null, false, false)).keyword(new Keyword[]{Keyword.SELECT}).commaSeparated(select.entrySet(), (QueryBuilder.Appender)new QueryBuilder.Appender<Map.Entry<String, String>>(){

            public void append(QueryBuilder qb, Map.Entry<String, String> entry) {
                String value = entry.getValue() == null ? "null" : entry.getValue();
                qb.append((Object)value).append((Object)" as ").append((Object)entry.getKey());
            }
        }).keyword(new Keyword[]{Keyword.FROM}).openParenthesis().append((Object)"select name, type from sqlite_master").closeParenthesis().keyword(new Keyword[]{Keyword.WHERE}).append((Object)" TABLE_NAME like ").append((Object)tableNamePattern).append((Object)" && TABLE_TYPE in ").openParenthesis().commaSeparated(Arrays.asList(types)).closeParenthesis().keyword(new Keyword[]{Keyword.ORDER, Keyword.BY}).append((Object)" TABLE_TYPE, TABLE_NAME");
        return this.queryMemory(new Function<Cursor, ResultSet>(){

            public ResultSet apply(Cursor cursor) {
                return new CursorResultSet(null, cursor, true);
            }
        }, qb.toString());
    }

    @Override
    public ResultSet getTableTypes() throws java.sql.SQLException {
        return this.queryMemory(new Function<Cursor, ResultSet>(){

            public ResultSet apply(Cursor cursor) {
                return new CursorResultSet(null, cursor, true);
            }
        }, "select 'TABLE' as TABLE_TYPE, 'VIEW' as TABLE_TYPE");
    }

    @Override
    public String getTimeDateFunctions() throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getTypeInfo() throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws java.sql.SQLException {
        return null;
    }

    @Override
    public String getURL() throws java.sql.SQLException {
        return null;
    }

    @Override
    public String getUserName() throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws java.sql.SQLException {
        return null;
    }

    @Override
    public boolean insertsAreDetected(int type) throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly() throws java.sql.SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean locatorsUpdateCopy() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws java.sql.SQLException {
        return concurrency == 1007;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws java.sql.SQLException {
        switch (holdability) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws java.sql.SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsSavepoints() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws java.sql.SQLException {
        switch (level) {
            case 1: 
            case 2: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTransactions() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int type) throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws java.sql.SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws java.sql.SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws java.sql.SQLException {
        return null;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws java.sql.SQLException {
        return null;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws java.sql.SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws java.sql.SQLException {
        return null;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws java.sql.SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws java.sql.SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws java.sql.SQLException {
        return false;
    }
}

