/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android;

import android.os.Parcel;
import android.os.Parcelable;
import io.requery.meta.Attribute;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import io.requery.proxy.PropertyState;

public class EntityParceler<T> {
    private final Type<T> type;

    public EntityParceler(Type<T> type) {
        this.type = type;
    }

    public T readFromParcel(Parcel in) {
        Object entity = this.type.getFactory().get();
        EntityProxy proxy = (EntityProxy)this.type.getProxyProvider().apply(entity);
        for (Attribute attribute : this.type.getAttributes()) {
            if (attribute.isAssociation()) continue;
            Class typeClass = attribute.getClassType();
            Object[] value = null;
            if (typeClass.isEnum()) {
                String name = (String)in.readValue(this.getClass().getClassLoader());
                if (name == null) {
                    value = null;
                } else {
                    Class enumClass = typeClass;
                    value = Enum.valueOf(enumClass, name);
                }
            } else if (typeClass.isArray()) {
                int length = in.readInt();
                if (length >= 0) {
                    try {
                        Parcelable.Creator creator = (Parcelable.Creator)typeClass.getField("CREATOR").get(null);
                        Object[] array = creator.newArray(length);
                        in.readTypedArray(array, creator);
                        value = array;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                value = in.readValue(this.getClass().getClassLoader());
            }
            PropertyState state = PropertyState.LOADED;
            if (!this.type.isStateless()) {
                state = PropertyState.valueOf((String)in.readString());
            }
            proxy.setObject(attribute, (Object)value, state);
        }
        return (T)entity;
    }

    public void writeToParcel(T entity, Parcel out) {
        EntityProxy proxy = (EntityProxy)this.type.getProxyProvider().apply(entity);
        for (Attribute attribute : this.type.getAttributes()) {
            if (attribute.isAssociation()) continue;
            Object value = proxy.get(attribute, false);
            Class typeClass = attribute.getClassType();
            if (typeClass.isArray()) {
                Parcelable[] array = (Parcelable[])value;
                if (array == null) {
                    out.writeInt(-1);
                } else {
                    out.writeInt(array.length);
                    out.writeTypedArray(array, 0);
                }
            } else {
                if (typeClass.isEnum() && value != null) {
                    value = value.toString();
                }
                out.writeValue(value);
            }
            if (this.type.isStateless()) continue;
            PropertyState state = proxy.getState(attribute);
            out.writeString(state.toString());
        }
    }
}

