/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android;

import android.database.Cursor;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import io.requery.android.QueryAdapter;
import io.requery.meta.EntityModel;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import io.requery.query.Result;
import io.requery.sql.ResultSetIterator;
import io.requery.util.CloseableIterator;
import io.requery.util.function.Function;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003B\u001d\b\u0014\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bB\u0019\b\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0017\u0010\u001d\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001e\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016J'\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'H&\u00a2\u0006\u0002\u0010(J \u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H&J\u0006\u0010*\u001a\u00020\u001aJ\u000e\u0010+\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010,\u001a\u00020\u001a2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0015\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/requery/android/QueryAdapter;", "E", "Landroid/widget/BaseAdapter;", "Ljava/io/Closeable;", "model", "Lio/requery/meta/EntityModel;", "type", "Ljava/lang/Class;", "(Lio/requery/meta/EntityModel;Ljava/lang/Class;)V", "Lio/requery/meta/Type;", "(Lio/requery/meta/Type;)V", "createdExecutor", "", "executor", "Ljava/util/concurrent/ExecutorService;", "handler", "Landroid/os/Handler;", "iterator", "Lio/requery/sql/ResultSetIterator;", "proxyProvider", "Lio/requery/util/function/Function;", "Lio/requery/proxy/EntityProxy;", "queryFuture", "Ljava/util/concurrent/Future;", "Lio/requery/query/Result;", "close", "", "getCount", "", "getItem", "position", "(I)Ljava/lang/Object;", "getItemId", "", "getView", "Landroid/view/View;", "item", "convertView", "parent", "Landroid/view/ViewGroup;", "(Ljava/lang/Object;Landroid/view/View;Landroid/view/ViewGroup;)Landroid/view/View;", "performQuery", "queryAsync", "setExecutor", "setResult", "requery-android_release"})
public abstract class QueryAdapter<E>
extends BaseAdapter
implements Closeable {
    private final Handler handler;
    private final Function<E, EntityProxy<E>> proxyProvider;
    private ResultSetIterator<E> iterator;
    private boolean createdExecutor;
    private ExecutorService executor;
    private Future<Result<E>> queryFuture;

    @Override
    public void close() {
        if (this.queryFuture != null) {
            Future<Result<E>> future = this.queryFuture;
            if (future == null) {
                Intrinsics.throwNpe();
            }
            future.cancel(true);
        }
        ResultSetIterator<E> resultSetIterator = this.iterator;
        if (resultSetIterator != null) {
            resultSetIterator.close();
        }
        this.iterator = null;
    }

    public final void setExecutor(@NotNull ExecutorService executor) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        if (this.createdExecutor && this.executor != null) {
            ExecutorService executorService = this.executor;
            if (executorService == null) {
                Intrinsics.throwNpe();
            }
            executorService.shutdown();
        }
        this.executor = executor;
    }

    public final void setResult(@NotNull ResultSetIterator<E> iterator) {
        Intrinsics.checkParameterIsNotNull(iterator, (String)"iterator");
        this.close();
        this.iterator = iterator;
        this.notifyDataSetChanged();
    }

    public final void queryAsync() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
            this.createdExecutor = true;
        }
        if (this.queryFuture != null) {
            Future<Result<E>> future = this.queryFuture;
            if (future == null) {
                Intrinsics.throwNpe();
            }
            if (!future.isDone()) {
                Future<Result<E>> future2 = this.queryFuture;
                if (future2 == null) {
                    Intrinsics.throwNpe();
                }
                future2.cancel(true);
            }
        }
        ExecutorService executorService = this.executor;
        if (executorService == null) {
            Intrinsics.throwNpe();
        }
        this.queryFuture = executorService.submit(new Callable<Result<E>>(this){
            final /* synthetic */ QueryAdapter this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Result<E> call() {
                void var1_1;
                Result<E> result = this.this$0.performQuery();
                QueryAdapter.access$getHandler$p(this.this$0).post(new Runnable(this, result){
                    final /* synthetic */ queryAsync.1 this$0;
                    final /* synthetic */ Result $result;

                    public final void run() {
                        CloseableIterator closeableIterator = this.$result.iterator();
                        if (closeableIterator == null) {
                            throw new TypeCastException("null cannot be cast to non-null type io.requery.sql.ResultSetIterator<E>");
                        }
                        this.this$0.this$0.setResult((ResultSetIterator)closeableIterator);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$result = result;
                    }
                });
                return var1_1;
            }
            {
                this.this$0 = queryAdapter;
            }
        });
    }

    @NotNull
    public abstract Result<E> performQuery();

    @Nullable
    public E getItem(int position) {
        Object object;
        if (this.iterator == null) {
            object = null;
        } else {
            ResultSetIterator<E> resultSetIterator = this.iterator;
            if (resultSetIterator == null) {
                Intrinsics.throwNpe();
            }
            object = resultSetIterator.get(position);
        }
        return (E)object;
    }

    @NotNull
    public View getView(int position, @NotNull View convertView, @NotNull ViewGroup parent) {
        Intrinsics.checkParameterIsNotNull((Object)convertView, (String)"convertView");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        E item = this.getItem(position);
        return this.getView(item, convertView, parent);
    }

    @NotNull
    public abstract View getView(@Nullable E var1, @NotNull View var2, @NotNull ViewGroup var3);

    public long getItemId(int position) {
        int n;
        ResultSetIterator<E> resultSetIterator = this.iterator;
        if (resultSetIterator == null) {
            Intrinsics.throwNpe();
        }
        Object item = resultSetIterator.get(position);
        Object key = null;
        if (this.proxyProvider != null) {
            EntityProxy proxy = (EntityProxy)this.proxyProvider.apply(item);
            key = proxy.key();
        }
        if (key == null) {
            Object object = item;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            n = object.hashCode();
        } else {
            n = key.hashCode();
        }
        return n;
    }

    public int getCount() {
        if (this.iterator == null) {
            return 0;
        }
        try {
            Cursor cursor;
            ResultSetIterator<E> resultSetIterator = this.iterator;
            if (resultSetIterator == null) {
                Intrinsics.throwNpe();
            }
            Cursor cursor2 = cursor = (Cursor)resultSetIterator.unwrap(Cursor.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
            return cursor2.getCount();
        }
        catch (SQLException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @JvmOverloads
    protected QueryAdapter(@Nullable Type<E> type) {
        this.handler = new Handler();
        Type<E> type2 = type;
        this.proxyProvider = type2 != null ? type2.getProxyProvider() : null;
    }

    @JvmOverloads
    public /* synthetic */ QueryAdapter(Type type, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            type = null;
        }
        this(type);
    }

    @JvmOverloads
    protected QueryAdapter() {
        this(null, 1, null);
    }

    protected QueryAdapter(@NotNull EntityModel model, @NotNull Class<E> type) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        this(model.typeOf(type));
    }

    @NotNull
    public static final /* synthetic */ Handler access$getHandler$p(QueryAdapter $this) {
        return $this.handler;
    }
}

