/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlcipher;

import android.content.Context;
import io.requery.android.DefaultMapping;
import io.requery.android.LoggingListener;
import io.requery.android.sqlcipher.SqlCipherConnection;
import io.requery.android.sqlite.DatabaseProvider;
import io.requery.android.sqlite.SchemaUpdater;
import io.requery.meta.EntityModel;
import io.requery.sql.Configuration;
import io.requery.sql.ConfigurationBuilder;
import io.requery.sql.ConnectionProvider;
import io.requery.sql.Mapping;
import io.requery.sql.Platform;
import io.requery.sql.SchemaModifier;
import io.requery.sql.StatementListener;
import io.requery.sql.TableCreationMode;
import io.requery.sql.platform.SQLite;
import io.requery.util.function.Function;
import java.sql.Connection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.sqlcipher.Cursor;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteOpenHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001a\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0004J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u0012\u0010%\u001a\u00020 2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010&\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\fH\u0016J\u0010\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u0012H\u0016J\u0010\u0010+\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/requery/android/sqlcipher/SqlCipherDatabaseSource;", "Lnet/sqlcipher/database/SQLiteOpenHelper;", "Lio/requery/android/sqlite/DatabaseProvider;", "Lnet/sqlcipher/database/SQLiteDatabase;", "context", "Landroid/content/Context;", "model", "Lio/requery/meta/EntityModel;", "name", "", "password", "version", "", "(Landroid/content/Context;Lio/requery/meta/EntityModel;Ljava/lang/String;Ljava/lang/String;I)V", "_configuration", "Lio/requery/sql/Configuration;", "db", "loggingEnabled", "", "mapping", "Lio/requery/sql/Mapping;", "mode", "Lio/requery/sql/TableCreationMode;", "platform", "Lio/requery/sql/Platform;", "getConfiguration", "getConnection", "Ljava/sql/Connection;", "Lio/requery/android/sqlcipher/SqlCipherConnection;", "getReadableDatabase", "getWritableDatabase", "onConfigure", "", "builder", "Lio/requery/sql/ConfigurationBuilder;", "onCreate", "onCreateMapping", "onOpen", "onUpgrade", "oldVersion", "newVersion", "setLoggingEnabled", "enable", "setTableCreationMode", "requery-android_release"})
public final class SqlCipherDatabaseSource
extends SQLiteOpenHelper
implements DatabaseProvider<SQLiteDatabase> {
    private final Platform platform;
    private final Mapping mapping;
    private SQLiteDatabase db;
    private Configuration _configuration;
    private boolean loggingEnabled;
    private TableCreationMode mode;
    private final EntityModel model;
    private final String password;

    @Override
    public void setLoggingEnabled(boolean enable) {
        this.loggingEnabled = enable;
    }

    @Override
    public void setTableCreationMode(@NotNull TableCreationMode mode) {
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        this.mode = mode;
    }

    @NotNull
    protected final Mapping onCreateMapping(@NotNull Platform platform) {
        Intrinsics.checkParameterIsNotNull((Object)platform, (String)"platform");
        return (Mapping)new DefaultMapping(platform);
    }

    @Override
    protected final void onConfigure(@NotNull ConfigurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        if (this.loggingEnabled) {
            LoggingListener loggingListener = new LoggingListener(null, 1, null);
            builder.addStatementListener((StatementListener)loggingListener);
        }
    }

    @Override
    @NotNull
    public SQLiteDatabase getReadableDatabase() {
        SQLiteDatabase sQLiteDatabase = this.getReadableDatabase(this.password);
        Intrinsics.checkExpressionValueIsNotNull((Object)sQLiteDatabase, (String)"getReadableDatabase(password)");
        return sQLiteDatabase;
    }

    @Override
    @NotNull
    public SQLiteDatabase getWritableDatabase() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(this.password);
        Intrinsics.checkExpressionValueIsNotNull((Object)sQLiteDatabase, (String)"getWritableDatabase(password)");
        return sQLiteDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SqlCipherConnection getConnection(SQLiteDatabase db) {
        SqlCipherDatabaseSource sqlCipherDatabaseSource = this;
        synchronized (sqlCipherDatabaseSource) {
            SqlCipherConnection sqlCipherConnection = new SqlCipherConnection(db);
            return sqlCipherConnection;
        }
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        if (this._configuration == null) {
            ConfigurationBuilder builder;
            ConfigurationBuilder configurationBuilder = builder = new ConfigurationBuilder((ConnectionProvider)this, this.model).setMapping(this.mapping).setPlatform(this.platform).setBatchUpdateSize(1000);
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationBuilder, (String)"builder");
            this.onConfigure(configurationBuilder);
            this._configuration = builder.build();
        }
        Configuration configuration = this._configuration;
        if (configuration == null) {
            Intrinsics.throwNpe();
        }
        return configuration;
    }

    @Override
    public void onCreate(@NotNull SQLiteDatabase db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        this.db = db;
        new SchemaModifier(this.getConfiguration()).createTables(TableCreationMode.CREATE);
    }

    @Override
    public void onConfigure(@NotNull SQLiteDatabase db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
    }

    public void onOpen(@Nullable SQLiteDatabase db) {
        super.onOpen(db);
        SQLiteDatabase sQLiteDatabase = db;
        if (sQLiteDatabase == null) {
            Intrinsics.throwNpe();
        }
        if (!sQLiteDatabase.isReadOnly()) {
            db.execSQL("PRAGMA foreign_keys = ON");
        }
    }

    @Override
    public void onUpgrade(@NotNull SQLiteDatabase db, int oldVersion, int newVersion) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        this.db = db;
        SchemaUpdater updater2 = new SchemaUpdater(this.getConfiguration(), (Function<String, android.database.Cursor>)((Function)new Function<String, android.database.Cursor>(db){
            final /* synthetic */ SQLiteDatabase $db;

            public final Cursor apply(String s) {
                return this.$db.rawQuery(s, null);
            }
            {
                this.$db = sQLiteDatabase;
            }
        }), this.mode);
        updater2.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Connection getConnection() {
        SqlCipherDatabaseSource sqlCipherDatabaseSource = this;
        synchronized (sqlCipherDatabaseSource) {
            if (this.db == null) {
                this.db = this.getWritableDatabase(this.password);
            }
            SQLiteDatabase sQLiteDatabase = this.db;
            if (sQLiteDatabase == null) {
                Intrinsics.throwNpe();
            }
            Connection connection = this.getConnection(sQLiteDatabase);
            return connection;
        }
    }

    public SqlCipherDatabaseSource(@NotNull Context context, @NotNull EntityModel model, @NotNull String name, @NotNull String password, int version) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        super(context, name, null, version);
        this.model = model;
        this.password = password;
        this.platform = (Platform)new SQLite();
        this.mapping = this.onCreateMapping(this.platform);
        this.mode = TableCreationMode.CREATE_NOT_EXISTS;
        SQLiteDatabase.loadLibs((Context)context);
    }
}

