/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlcipher;

import android.database.Cursor;
import io.requery.android.sqlcipher.SqlCipherConnection;
import io.requery.android.sqlite.BasePreparedStatement;
import io.requery.android.sqlite.CursorResultSet;
import io.requery.android.sqlite.SingleResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.sqlcipher.database.SQLiteException;
import net.sqlcipher.database.SQLiteStatement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0015H\u0014J\u001a\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/requery/android/sqlcipher/SqlCipherPreparedStatement;", "Lio/requery/android/sqlite/BasePreparedStatement;", "cipherConnection", "Lio/requery/android/sqlcipher/SqlCipherConnection;", "sql", "", "autoGeneratedKeys", "", "(Lio/requery/android/sqlcipher/SqlCipherConnection;Ljava/lang/String;I)V", "cursor", "Landroid/database/Cursor;", "statement", "Lnet/sqlcipher/database/SQLiteStatement;", "bindBlob", "", "index", "value", "", "bindDouble", "", "bindLong", "", "bindNullOrString", "", "clearParameters", "close", "execute", "", "executeQuery", "Ljava/sql/ResultSet;", "executeUpdate", "requery-android_release"})
public final class SqlCipherPreparedStatement
extends BasePreparedStatement {
    private final SQLiteStatement statement;
    private Cursor cursor;
    private final SqlCipherConnection cipherConnection;

    @Override
    protected void bindNullOrString(int index, @Nullable Object value) {
        block1: {
            block0: {
                if (value != null) break block0;
                this.statement.bindNull(index);
                List list = this.bindings;
                if (list == null) break block1;
                list.add(null);
                break block1;
            }
            String string = value.toString();
            this.statement.bindString(index, string);
            List list = this.bindings;
            if (list == null) break block1;
            list.add(string);
        }
    }

    @Override
    protected void bindLong(int index, long value) {
        block0: {
            this.statement.bindLong(index, value);
            List list = this.bindings;
            if (list == null) break block0;
            list.add(value);
        }
    }

    @Override
    protected void bindDouble(int index, double value) {
        block0: {
            this.statement.bindDouble(index, value);
            List list = this.bindings;
            if (list == null) break block0;
            list.add(value);
        }
    }

    @Override
    protected void bindBlob(int index, @Nullable byte[] value) {
        if (value == null) {
            this.statement.bindNull(index);
            List list = this.bindings;
            if (list != null) {
                list.add(null);
            }
        } else {
            this.statement.bindBlob(index, value);
            if (this.bindings != null) {
                this.bindBlobLiteral(index, value);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.clearParameters();
        this.statement.close();
        Cursor cursor = this.cursor;
        if (cursor != null) {
            cursor.close();
        }
        super.close();
    }

    @Override
    public boolean execute(@NotNull String sql, int autoGeneratedKeys) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ResultSet executeQuery(@NotNull String sql) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(@NotNull String sql, int autoGeneratedKeys) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    public void clearParameters() {
        block0: {
            this.statement.clearBindings();
            List list = this.bindings;
            if (list == null) break block0;
            list.clear();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            this.statement.execute();
        }
        catch (SQLiteException e) {
            SqlCipherConnection.Companion.throwSQLException(e);
        }
        return false;
    }

    @Override
    @Nullable
    public ResultSet executeQuery() throws SQLException {
        try {
            String[] args = this.bindingsToArray();
            this.cursor = (Cursor)this.cipherConnection.getDatabase().rawQuery(this.getSql(), args);
            Statement statement = this;
            Cursor cursor = this.cursor;
            if (cursor == null) {
                Intrinsics.throwNpe();
            }
            this.queryResult = new CursorResultSet(statement, cursor, false);
            return this.queryResult;
        }
        catch (SQLiteException e) {
            SqlCipherConnection.Companion.throwSQLException(e);
            return null;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.autoGeneratedKeys == 1) {
            try {
                long rowId = this.statement.executeInsert();
                this.insertResult = new SingleResultSet(this, rowId);
                this.updateCount = 1;
            }
            catch (SQLiteException e) {
                SqlCipherConnection.Companion.throwSQLException(e);
            }
        } else {
            try {
                this.updateCount = this.statement.executeUpdateDelete();
            }
            catch (SQLiteException e) {
                SqlCipherConnection.Companion.throwSQLException(e);
            }
        }
        return this.updateCount;
    }

    public SqlCipherPreparedStatement(@NotNull SqlCipherConnection cipherConnection, @NotNull String sql, int autoGeneratedKeys) throws SQLException {
        Intrinsics.checkParameterIsNotNull((Object)cipherConnection, (String)"cipherConnection");
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        super(cipherConnection, sql, autoGeneratedKeys);
        this.cipherConnection = cipherConnection;
        SQLiteStatement sQLiteStatement = this.cipherConnection.getDatabase().compileStatement(sql);
        Intrinsics.checkExpressionValueIsNotNull((Object)sQLiteStatement, (String)"cipherConnection.database.compileStatement(sql)");
        this.statement = sQLiteStatement;
    }
}

