/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlite;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import io.requery.android.DefaultMapping;
import io.requery.android.LoggingListener;
import io.requery.android.sqlite.DatabaseProvider;
import io.requery.android.sqlite.SchemaUpdater;
import io.requery.android.sqlite.SqliteConnection;
import io.requery.meta.EntityModel;
import io.requery.sql.Configuration;
import io.requery.sql.ConfigurationBuilder;
import io.requery.sql.ConnectionProvider;
import io.requery.sql.Mapping;
import io.requery.sql.Platform;
import io.requery.sql.SchemaModifier;
import io.requery.sql.StatementListener;
import io.requery.sql.TableCreationMode;
import io.requery.sql.platform.SQLite;
import io.requery.util.function.Function;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 -2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001-B\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rB?\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0003H\u0017J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0004J\u0010\u0010%\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u001dH\u0004J \u0010'\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tH\u0016J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u0016H\u0016J\u0010\u0010,\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/requery/android/sqlite/DatabaseSource;", "Landroid/database/sqlite/SQLiteOpenHelper;", "Lio/requery/android/sqlite/DatabaseProvider;", "Landroid/database/sqlite/SQLiteDatabase;", "context", "Landroid/content/Context;", "model", "Lio/requery/meta/EntityModel;", "version", "", "(Landroid/content/Context;Lio/requery/meta/EntityModel;I)V", "name", "", "(Landroid/content/Context;Lio/requery/meta/EntityModel;Ljava/lang/String;I)V", "factory", "Landroid/database/sqlite/SQLiteDatabase$CursorFactory;", "platform", "Lio/requery/sql/platform/SQLite;", "(Landroid/content/Context;Lio/requery/meta/EntityModel;Ljava/lang/String;Landroid/database/sqlite/SQLiteDatabase$CursorFactory;ILio/requery/sql/platform/SQLite;)V", "configuration", "Lio/requery/sql/Configuration;", "configured", "", "db", "loggingEnabled", "mapping", "Lio/requery/sql/Mapping;", "mode", "Lio/requery/sql/TableCreationMode;", "Lio/requery/sql/Platform;", "getConfiguration", "getConnection", "Ljava/sql/Connection;", "onConfigure", "", "builder", "Lio/requery/sql/ConfigurationBuilder;", "onCreate", "onCreateMapping", "onUpgrade", "oldVersion", "newVersion", "setLoggingEnabled", "enable", "setTableCreationMode", "Companion", "requery-android_release"})
public class DatabaseSource
extends SQLiteOpenHelper
implements DatabaseProvider<SQLiteDatabase> {
    private final Platform platform;
    private Mapping mapping;
    private SQLiteDatabase db;
    private Configuration configuration;
    private boolean configured;
    private boolean loggingEnabled;
    private TableCreationMode mode;
    private final EntityModel model;
    public static final Companion Companion = new Companion(null);

    @Override
    public void setLoggingEnabled(boolean enable) {
        this.loggingEnabled = enable;
    }

    @Override
    public void setTableCreationMode(@NotNull TableCreationMode mode) {
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        this.mode = mode;
    }

    @NotNull
    protected final Mapping onCreateMapping(@NotNull Platform platform) {
        Intrinsics.checkParameterIsNotNull((Object)platform, (String)"platform");
        return (Mapping)new DefaultMapping(platform);
    }

    @Override
    protected final void onConfigure(@NotNull ConfigurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        if (this.loggingEnabled) {
            LoggingListener loggingListener = new LoggingListener(null, 1, null);
            builder.addStatementListener((StatementListener)loggingListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Connection getConnection(SQLiteDatabase db) throws SQLException {
        DatabaseSource databaseSource = this;
        synchronized (databaseSource) {
            if (!db.isOpen()) {
                throw (Throwable)new SQLNonTransientConnectionException();
            }
            Connection connection = new SqliteConnection(db);
            return connection;
        }
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        if (this.mapping == null) {
            this.mapping = this.onCreateMapping(this.platform);
        }
        if (this.mapping == null) {
            throw (Throwable)new IllegalStateException();
        }
        if (this.configuration == null) {
            ConfigurationBuilder builder;
            ConfigurationBuilder configurationBuilder = builder = new ConfigurationBuilder((ConnectionProvider)this, this.model).setMapping(this.mapping).setPlatform(this.platform).setBatchUpdateSize(1000);
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationBuilder, (String)"builder");
            this.onConfigure(configurationBuilder);
            this.configuration = builder.build();
        }
        Configuration configuration = this.configuration;
        if (configuration == null) {
            Intrinsics.throwNpe();
        }
        return configuration;
    }

    @Override
    public void onCreate(@NotNull SQLiteDatabase db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        this.db = db;
        Configuration configuration = this.getConfiguration();
        if (configuration == null) {
            Intrinsics.throwNpe();
        }
        new SchemaModifier(configuration).createTables(TableCreationMode.CREATE);
    }

    @Override
    @TargetApi(value=16)
    public void onConfigure(@NotNull SQLiteDatabase db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        super.onConfigure(db);
        if (!db.isReadOnly()) {
            db.setForeignKeyConstraintsEnabled(true);
        }
    }

    @Override
    public void onUpgrade(@NotNull SQLiteDatabase db, int oldVersion, int newVersion) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        this.db = db;
        SchemaUpdater updater2 = new SchemaUpdater(this.getConfiguration(), (Function<String, Cursor>)((Function)new Function<String, Cursor>(db){
            final /* synthetic */ SQLiteDatabase $db;

            public final Cursor apply(String s) {
                return this.$db.rawQuery(s, null);
            }
            {
                this.$db = sQLiteDatabase;
            }
        }), this.mode);
        updater2.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Connection getConnection() throws SQLException {
        DatabaseSource databaseSource = this;
        synchronized (databaseSource) {
            if (this.db == null) {
                this.db = this.getWritableDatabase();
            }
            if (!this.configured && Build.VERSION.SDK_INT < 16) {
                long pageSize;
                SQLiteDatabase sQLiteDatabase = this.db;
                if (sQLiteDatabase == null) {
                    Intrinsics.throwNpe();
                }
                sQLiteDatabase.execSQL("PRAGMA foreign_keys = ON");
                SQLiteDatabase sQLiteDatabase2 = this.db;
                if (sQLiteDatabase2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((pageSize = sQLiteDatabase2.getPageSize()) == 1024L) {
                    SQLiteDatabase sQLiteDatabase3 = this.db;
                    if (sQLiteDatabase3 == null) {
                        Intrinsics.throwNpe();
                    }
                    sQLiteDatabase3.setPageSize(4096L);
                }
                this.configured = true;
            }
            SQLiteDatabase sQLiteDatabase = this.db;
            if (sQLiteDatabase == null) {
                Intrinsics.throwNpe();
            }
            Connection connection = this.getConnection(sQLiteDatabase);
            return connection;
        }
    }

    @JvmOverloads
    public DatabaseSource(@NotNull Context context, @Nullable EntityModel model, @Nullable String name, @Nullable SQLiteDatabase.CursorFactory factory, int version, @NotNull SQLite platform) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)platform, (String)"platform");
        super(context, name, factory, version);
        this.model = model;
        if (this.model == null) {
            throw (Throwable)new IllegalArgumentException("null model");
        }
        this.platform = (Platform)platform;
        this.mode = TableCreationMode.CREATE_NOT_EXISTS;
    }

    @JvmOverloads
    public /* synthetic */ DatabaseSource(Context context, EntityModel entityModel, String string, SQLiteDatabase.CursorFactory cursorFactory, int n, SQLite sQLite, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            sQLite = new SQLite();
        }
        this(context, entityModel, string, cursorFactory, n, sQLite);
    }

    @JvmOverloads
    public DatabaseSource(@NotNull Context context, @Nullable EntityModel model, @Nullable String name, @Nullable SQLiteDatabase.CursorFactory factory, int version) {
        this(context, model, name, factory, version, null, 32, null);
    }

    public DatabaseSource(@NotNull Context context, @NotNull EntityModel model, int version) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        this(context, model, DatabaseSource.Companion.getDefaultDatabaseName(context, model), null, version, null, 32, null);
    }

    public DatabaseSource(@NotNull Context context, @NotNull EntityModel model, @Nullable String name, int version) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        this(context, model, name, null, version, null, 32, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lio/requery/android/sqlite/DatabaseSource$Companion;", "", "()V", "getDefaultDatabaseName", "", "context", "Landroid/content/Context;", "model", "Lio/requery/meta/EntityModel;", "requery-android_release"})
    public static final class Companion {
        private final String getDefaultDatabaseName(Context context, EntityModel model) {
            String string;
            if (TextUtils.isEmpty((CharSequence)model.getName())) {
                String string2 = context.getPackageName();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.packageName");
            } else {
                String string3 = model.getName();
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"model.name");
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

