/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlite;

import android.database.Cursor;
import io.requery.android.sqlite.SchemaUpdater;
import io.requery.meta.Attribute;
import io.requery.meta.EntityModel;
import io.requery.meta.Type;
import io.requery.sql.Configuration;
import io.requery.sql.SchemaModifier;
import io.requery.sql.TableCreationMode;
import io.requery.sql.TableModificationException;
import io.requery.util.function.Function;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/requery/android/sqlite/SchemaUpdater;", "", "configuration", "Lio/requery/sql/Configuration;", "queryFunction", "Lio/requery/util/function/Function;", "", "Landroid/database/Cursor;", "mode", "Lio/requery/sql/TableCreationMode;", "(Lio/requery/sql/Configuration;Lio/requery/util/function/Function;Lio/requery/sql/TableCreationMode;)V", "update", "", "upgrade", "connection", "Ljava/sql/Connection;", "schema", "Lio/requery/sql/SchemaModifier;", "requery-android_release"})
public final class SchemaUpdater {
    private final TableCreationMode mode;
    private final Configuration configuration;
    private final Function<String, Cursor> queryFunction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update() {
        SchemaModifier schema = new SchemaModifier(this.configuration);
        if (this.mode == TableCreationMode.DROP_CREATE) {
            schema.createTables(this.mode);
        } else {
            try {
                AutoCloseable autoCloseable = schema.getConnection();
                Throwable throwable = null;
                try {
                    Connection connection;
                    Connection connection2 = connection = (Connection)autoCloseable;
                    Intrinsics.checkExpressionValueIsNotNull((Object)connection2, (String)"connection");
                    connection2.setAutoCommit(false);
                    this.upgrade(connection, schema);
                    connection.commit();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (SQLException e) {
                throw (Throwable)new TableModificationException((Throwable)e);
            }
        }
    }

    private final void upgrade(Connection connection, SchemaModifier schema) {
        schema.createTables(connection, this.mode, false);
        Function columnTransformer = this.configuration.getColumnTransformer();
        Function tableTransformer = this.configuration.getTableTransformer();
        ArrayList missingAttributes = new ArrayList();
        EntityModel entityModel = this.configuration.getModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityModel, (String)"configuration.model");
        Iterator iterator = entityModel.getTypes().iterator();
        while (iterator.hasNext()) {
            Type type;
            Type type2 = type = (Type)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"type");
            if (type2.isView()) continue;
            String tableName = type.getName();
            if (tableTransformer != null) {
                tableName = (String)tableTransformer.apply((Object)tableName);
            }
            Cursor cursor = (Cursor)this.queryFunction.apply((Object)("PRAGMA table_info(" + tableName + ')'));
            LinkedHashMap map = new LinkedHashMap();
            Iterator iterator2 = type.getAttributes().iterator();
            while (iterator2.hasNext()) {
                Object object;
                Attribute attribute;
                Map map2;
                Attribute attribute2;
                Attribute attribute3 = attribute2 = (Attribute)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)attribute3, (String)"attribute");
                if (attribute3.isAssociation() && !attribute2.isForeignKey()) continue;
                if (columnTransformer == null) {
                    map2 = map;
                    Intrinsics.checkExpressionValueIsNotNull((Object)attribute2.getName(), (String)"attribute.name");
                    attribute = attribute2;
                    map2.put(object, attribute);
                    continue;
                }
                map2 = map;
                Intrinsics.checkExpressionValueIsNotNull((Object)columnTransformer.apply((Object)attribute2.getName()), (String)"columnTransformer.apply(attribute.name)");
                attribute = attribute2;
                map2.put(object, attribute);
            }
            Cursor cursor2 = cursor;
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
            if (cursor2.getCount() > 0) {
                int nameIndex = cursor.getColumnIndex("name");
                while (cursor.moveToNext()) {
                    String name = cursor.getString(nameIndex);
                    map.remove(name);
                }
            }
            cursor.close();
            missingAttributes.addAll(map.values());
        }
        Collections.sort(missingAttributes, upgrade.1.INSTANCE);
        for (Attribute attribute : missingAttributes) {
            schema.addColumn(connection, attribute, false);
            Attribute attribute4 = attribute;
            Intrinsics.checkExpressionValueIsNotNull((Object)attribute4, (String)"attribute");
            if (!attribute4.isUnique() || attribute.isIndexed()) continue;
            schema.createIndex(connection, attribute, this.mode);
        }
        schema.createIndexes(connection, this.mode);
    }

    public SchemaUpdater(@NotNull Configuration configuration, @NotNull Function<String, Cursor> queryFunction, @Nullable TableCreationMode mode) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(queryFunction, (String)"queryFunction");
        this.configuration = configuration;
        this.queryFunction = queryFunction;
        TableCreationMode tableCreationMode = mode;
        if (tableCreationMode == null) {
            tableCreationMode = TableCreationMode.CREATE_NOT_EXISTS;
        }
        this.mode = tableCreationMode;
    }
}

