/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlitex;

import android.database.SQLException;
import android.database.sqlite.SQLiteException;
import io.requery.android.database.sqlite.SQLiteDatabase;
import io.requery.android.sqlite.BaseConnection;
import io.requery.android.sqlitex.SqlitexMetaData;
import io.requery.android.sqlitex.SqlitexPreparedStatement;
import io.requery.android.sqlitex.SqlitexStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\fH\u0014J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J#\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0010H\u0016J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010!\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/requery/android/sqlitex/SqlitexConnection;", "Lio/requery/android/sqlite/BaseConnection;", "database", "Lio/requery/android/database/sqlite/SQLiteDatabase;", "(Lio/requery/android/database/sqlite/SQLiteDatabase;)V", "getDatabase", "()Lio/requery/android/database/sqlite/SQLiteDatabase;", "enteredTransaction", "", "metaData", "Lio/requery/android/sqlitex/SqlitexMetaData;", "commit", "", "createStatement", "Ljava/sql/Statement;", "resultSetType", "", "resultSetConcurrency", "resultSetHoldability", "ensureTransaction", "execSQL", "sql", "", "getMetaData", "Ljava/sql/DatabaseMetaData;", "isClosed", "isReadOnly", "prepareStatement", "Ljava/sql/PreparedStatement;", "columnNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;", "autoGeneratedKeys", "rollback", "requery-android_release"})
public final class SqlitexConnection
extends BaseConnection {
    private final SqlitexMetaData metaData;
    private boolean enteredTransaction;
    @NotNull
    private final SQLiteDatabase database;

    @Override
    protected void ensureTransaction() {
        if (!this.getAutoCommit() && !this.database.inTransaction()) {
            this.database.beginTransaction();
            this.enteredTransaction = true;
        }
    }

    @Override
    public void execSQL(@NotNull String sql) throws java.sql.SQLException {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        try {
            this.database.execSQL(sql);
        }
        catch (SQLiteException e) {
            BaseConnection.Companion.throwSQLException((SQLException)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws java.sql.SQLException {
        if (this.getAutoCommit()) {
            throw (Throwable)new java.sql.SQLException("commit called while in autoCommit mode");
        }
        if (this.database.inTransaction() && this.enteredTransaction) {
            try {
                this.database.setTransactionSuccessful();
            }
            catch (IllegalStateException e) {
                throw (Throwable)new java.sql.SQLException(e);
            }
            finally {
                this.database.endTransaction();
                this.enteredTransaction = false;
            }
        }
    }

    @Override
    @NotNull
    public Statement createStatement() {
        return new SqlitexStatement(this);
    }

    @Override
    @NotNull
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws java.sql.SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    @NotNull
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws java.sql.SQLException {
        if (resultSetConcurrency == 1008) {
            throw (Throwable)new SQLFeatureNotSupportedException("CONCUR_UPDATABLE not supported");
        }
        return new SqlitexStatement(this);
    }

    @Override
    @NotNull
    public DatabaseMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public boolean isClosed() {
        return !this.database.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    @Override
    @NotNull
    public PreparedStatement prepareStatement(@NotNull String sql, int autoGeneratedKeys) throws java.sql.SQLException {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        return new SqlitexPreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    @NotNull
    public PreparedStatement prepareStatement(@NotNull String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws java.sql.SQLException {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        return new SqlitexPreparedStatement(this, sql, 2);
    }

    @Override
    @NotNull
    public PreparedStatement prepareStatement(@NotNull String sql, @NotNull String[] columnNames) throws java.sql.SQLException {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull((Object)columnNames, (String)"columnNames");
        return new SqlitexPreparedStatement(this, sql, 1);
    }

    @Override
    public void rollback() throws java.sql.SQLException {
        if (this.getAutoCommit()) {
            throw (Throwable)new java.sql.SQLException("commit called while in autoCommit mode");
        }
        this.database.endTransaction();
    }

    @NotNull
    public final SQLiteDatabase getDatabase() {
        return this.database;
    }

    public SqlitexConnection(@NotNull SQLiteDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        this.database = database;
        this.setAutoCommit(true);
        this.metaData = new SqlitexMetaData(this);
    }
}

