/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.CascadeAction;
import io.requery.Column;
import io.requery.Convert;
import io.requery.Embedded;
import io.requery.ForeignKey;
import io.requery.Generated;
import io.requery.Index;
import io.requery.JunctionTable;
import io.requery.Key;
import io.requery.Lazy;
import io.requery.ManyToMany;
import io.requery.ManyToOne;
import io.requery.Naming;
import io.requery.Nullable;
import io.requery.OneToMany;
import io.requery.OneToOne;
import io.requery.OrderBy;
import io.requery.PropertyNameStyle;
import io.requery.ReadOnly;
import io.requery.ReferentialAction;
import io.requery.Transient;
import io.requery.Version;
import io.requery.converter.EnumOrdinalConverter;
import io.requery.meta.AttributeBuilder;
import io.requery.meta.Cardinality;
import io.requery.meta.ListAttributeBuilder;
import io.requery.meta.MapAttributeBuilder;
import io.requery.meta.ResultAttributeBuilder;
import io.requery.meta.SetAttributeBuilder;
import io.requery.processor.AccessorNamePrefix;
import io.requery.processor.AssociativeEntityDescriptor;
import io.requery.processor.AttributeDescriptor;
import io.requery.processor.BaseProcessableElement;
import io.requery.processor.ElementValidator;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.JoinTableAssociation;
import io.requery.processor.JunctionTableAssociation;
import io.requery.processor.Mirrors;
import io.requery.processor.Names;
import io.requery.processor.ReservedKeyword;
import io.requery.query.Order;
import java.lang.annotation.Annotation;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.ConstraintMode;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;

class AttributeMember
extends BaseProcessableElement<Element>
implements AttributeDescriptor {
    private final EntityDescriptor entity;
    private String name;
    private boolean isBoolean;
    private boolean isEmbedded;
    private boolean isForeignKey;
    private boolean isGenerated;
    private boolean isIndexed;
    private boolean isIterable;
    private boolean isKey;
    private boolean isLazy;
    private boolean isMap;
    private boolean isNullable;
    private boolean isOptional;
    private boolean isReadOnly;
    private boolean isTransient;
    private boolean isUnique;
    private boolean isVersion;
    private AttributeDescriptor.Type type;
    private Class<? extends AttributeBuilder> builderClass;
    private Integer length;
    private Set<String> indexNames;
    private Cardinality cardinality;
    private String converterType;
    private CascadeAction[] cascadeActions;
    private ReferentialAction deleteAction;
    private ReferentialAction updateAction;
    private String referencedColumn;
    private String referencedType;
    private String referencedTable;
    private String mappedBy;
    private String defaultValue;
    private String definition;
    private String collate;
    private String optionalClassName;
    private String orderByColumn;
    private Order orderByDirection;
    private AssociativeEntityDescriptor associativeDescriptor;

    AttributeMember(Element element, EntityDescriptor entity) {
        super(element);
        if (!element.getKind().isField() && element.getKind() != ElementKind.METHOD) {
            throw new IllegalStateException();
        }
        this.entity = entity;
        this.indexNames = new LinkedHashSet<String>();
        this.type = AttributeDescriptor.Type.DEFAULT;
    }

    @Override
    public Set<ElementValidator> process(ProcessingEnvironment processingEnvironment) {
        LinkedHashSet<ElementValidator> validators = new LinkedHashSet<ElementValidator>();
        ElementValidator validator = new ElementValidator((Element)this.element(), processingEnvironment);
        validators.add(validator);
        this.validateField(validator);
        this.processFieldAccessAnnotations(validator);
        this.processBasicColumnAnnotations(validator);
        this.processAssociativeAnnotations(processingEnvironment, validator);
        this.processConverterAnnotation(validator);
        this.checkMemberType(processingEnvironment, validators);
        if (this.cardinality() != null && this.entity.isImmutable()) {
            validator.error("Immutable value type cannot contain relational references");
        }
        if (!this.isTransient) {
            this.checkReserved(this.name(), validator);
        }
        this.isEmbedded = this.annotationOf(Embedded.class).isPresent() || this.annotationOf(javax.persistence.Embedded.class).isPresent();
        this.indexNames.forEach(name -> this.checkReserved((String)name, validator));
        return validators;
    }

    private void validateField(ElementValidator validator) {
        if (this.element().getKind().isField()) {
            Set<Modifier> modifiers = this.element().getModifiers();
            if (!this.entity.isUnimplementable() && modifiers.contains((Object)Modifier.PRIVATE)) {
                validator.error("Entity field cannot be private");
            }
            if (modifiers.contains((Object)Modifier.STATIC)) {
                validator.error("Entity field cannot be static");
            }
            if (modifiers.contains((Object)Modifier.FINAL)) {
                validator.error("Entity field cannot be final");
            }
        }
    }

    private void checkMemberType(ProcessingEnvironment processingEnvironment, Set<ElementValidator> validators) {
        TypeElement element;
        this.builderClass = AttributeBuilder.class;
        Types types = processingEnvironment.getTypeUtils();
        TypeMirror mirror = this.typeMirror();
        boolean bl = this.isBoolean = mirror.getKind() == TypeKind.BOOLEAN;
        if (mirror.getKind() == TypeKind.DECLARED && (element = (TypeElement)types.asElement(mirror)) != null) {
            String[] names;
            if (this.cardinality != null) {
                this.isIterable = Mirrors.isInstance(types, element, Iterable.class);
            }
            this.isMap = Mirrors.isInstance(types, element, Map.class);
            if (this.isMap && this.cardinality != null) {
                this.builderClass = MapAttributeBuilder.class;
            }
            for (String name : names = new String[]{Optional.class.getName(), "com.google.common.base.Optional", "java8.util.Optional"}) {
                if (!Mirrors.isInstance(types, element, name)) continue;
                this.isOptional = true;
                this.optionalClassName = name;
                break;
            }
            this.isBoolean = Mirrors.isInstance(types, element, Boolean.class);
        }
        if (this.isIterable) {
            ElementValidator validator = this.validateCollectionType(processingEnvironment);
            if (validator != null) {
                validators.add(validator);
            }
        } else {
            element = null;
            if (mirror.getKind().isPrimitive()) {
                element = types.boxedClass((PrimitiveType)mirror);
            } else if (mirror.getKind() == TypeKind.DECLARED) {
                element = (TypeElement)types.asElement(mirror);
            }
            if (element != null) {
                if (Mirrors.isInstance(types, element, Number.class) || Mirrors.isInstance(types, element, Date.class) || Mirrors.isInstance(types, element, Temporal.class)) {
                    this.type = AttributeDescriptor.Type.NUMERIC;
                } else if (Mirrors.isInstance(types, element, String.class)) {
                    this.type = AttributeDescriptor.Type.STRING;
                }
            }
        }
    }

    private ElementValidator validateCollectionType(ProcessingEnvironment processingEnvironment) {
        Types types = processingEnvironment.getTypeUtils();
        TypeElement collectionElement = (TypeElement)types.asElement(this.typeMirror());
        if (collectionElement != null) {
            ElementValidator validator = new ElementValidator(collectionElement, processingEnvironment);
            if (Mirrors.isInstance(types, collectionElement, List.class)) {
                this.builderClass = ListAttributeBuilder.class;
            } else if (Mirrors.isInstance(types, collectionElement, Set.class)) {
                this.builderClass = SetAttributeBuilder.class;
            } else if (Mirrors.isInstance(types, collectionElement, Iterable.class)) {
                this.builderClass = ResultAttributeBuilder.class;
            } else {
                validator.error("Invalid collection type, must be Set, List or Iterable");
            }
            return validator;
        }
        return null;
    }

    private void processFieldAccessAnnotations(ElementValidator validator) {
        if (this.annotationOf(Transient.class).isPresent() || this.annotationOf(java.beans.Transient.class).isPresent() || this.annotationOf(javax.persistence.Transient.class).isPresent() || this.element().getModifiers().contains((Object)Modifier.TRANSIENT)) {
            this.isTransient = true;
        }
        this.isReadOnly = this.annotationOf(ReadOnly.class).isPresent();
        if (!SourceVersion.isIdentifier(this.getterName())) {
            validator.error("Invalid getter name " + this.getterName(), Naming.class);
        }
        if (!SourceVersion.isIdentifier(this.setterName())) {
            validator.error("Invalid setter name " + this.setterName(), Naming.class);
        }
    }

    private void processBasicColumnAnnotations(ElementValidator validator) {
        if (this.annotationOf(Key.class).isPresent() || this.annotationOf(Id.class).isPresent()) {
            this.isKey = true;
            if (this.isTransient) {
                validator.error("Key field cannot be transient");
            }
        }
        if (this.annotationOf(Generated.class).isPresent() || this.annotationOf(GeneratedValue.class).isPresent()) {
            this.isGenerated = true;
            this.isReadOnly = true;
            this.annotationOf(GeneratedValue.class).ifPresent(generatedValue -> {
                if (generatedValue.strategy() != GenerationType.IDENTITY && generatedValue.strategy() != GenerationType.AUTO) {
                    validator.warning("GeneratedValue.strategy() " + generatedValue.strategy() + " not supported", generatedValue.getClass());
                }
            });
        }
        if (this.annotationOf(Lazy.class).isPresent()) {
            if (this.isKey) {
                this.cannotCombine(validator, Key.class, Lazy.class);
            }
            this.isLazy = true;
        }
        if (this.annotationOf(Nullable.class).isPresent() || this.isOptional || Mirrors.findAnnotationMirror(this.element(), "javax.annotation.Nullable").isPresent()) {
            this.isNullable = true;
        } else if (this.element().getKind().isField()) {
            this.isNullable = !this.element().asType().getKind().isPrimitive();
        } else if (this.element().getKind() == ElementKind.METHOD) {
            ExecutableElement executableElement = (ExecutableElement)this.element();
            boolean bl = this.isNullable = !executableElement.getReturnType().getKind().isPrimitive();
        }
        if (this.annotationOf(Version.class).isPresent() || this.annotationOf(javax.persistence.Version.class).isPresent()) {
            this.isVersion = true;
            if (this.isKey) {
                this.cannotCombine(validator, Key.class, Version.class);
            }
        }
        Column column = this.annotationOf(Column.class).orElse(null);
        ForeignKey foreignKey = null;
        boolean foreignKeySetFromColumn = false;
        if (column != null) {
            this.name = "".equals(column.name()) ? null : column.name();
            this.isUnique = column.unique();
            this.isNullable = column.nullable();
            this.defaultValue = column.value();
            this.collate = column.collate();
            this.definition = column.definition();
            if (column.length() > 0) {
                this.length = column.length();
            }
            if (column.foreignKey().length > 0) {
                foreignKey = column.foreignKey()[0];
                foreignKeySetFromColumn = true;
            }
        }
        if (!foreignKeySetFromColumn) {
            foreignKey = this.annotationOf(ForeignKey.class).orElse(null);
        }
        if (foreignKey != null) {
            this.isForeignKey = true;
            this.deleteAction = foreignKey.delete();
            this.updateAction = foreignKey.update();
            this.referencedColumn = foreignKey.referencedColumn();
        }
        this.annotationOf(Index.class).ifPresent(index -> {
            this.isIndexed = true;
            Collections.addAll(this.indexNames, index.value());
        });
        this.annotationOf(Basic.class).ifPresent(basic -> {
            this.isNullable = basic.optional();
            this.isLazy = basic.fetch() == FetchType.LAZY;
        });
        this.annotationOf(javax.persistence.Index.class).ifPresent(index -> {
            this.isIndexed = true;
            Collections.addAll(this.indexNames, index.name());
        });
        this.annotationOf(JoinColumn.class).ifPresent(joinColumn -> {
            javax.persistence.ForeignKey joinForeignKey = joinColumn.foreignKey();
            this.isForeignKey = true;
            ConstraintMode constraintMode = joinForeignKey.value();
            switch (constraintMode) {
                default: {
                    this.deleteAction = ReferentialAction.CASCADE;
                    this.updateAction = ReferentialAction.CASCADE;
                    break;
                }
                case NO_CONSTRAINT: {
                    this.deleteAction = ReferentialAction.NO_ACTION;
                    this.updateAction = ReferentialAction.NO_ACTION;
                }
            }
            this.referencedTable = joinColumn.table();
            this.referencedColumn = joinColumn.referencedColumnName();
        });
        this.annotationOf(javax.persistence.Column.class).ifPresent(persistenceColumn -> {
            this.name = "".equals(persistenceColumn.name()) ? null : persistenceColumn.name();
            this.isUnique = persistenceColumn.unique();
            this.isNullable = persistenceColumn.nullable();
            this.length = persistenceColumn.length();
            this.isReadOnly = !persistenceColumn.updatable();
            this.definition = persistenceColumn.columnDefinition();
        });
        this.annotationOf(Enumerated.class).ifPresent(enumerated -> {
            EnumType enumType = enumerated.value();
            if (enumType == EnumType.ORDINAL) {
                this.converterType = EnumOrdinalConverter.class.getCanonicalName();
            }
        });
    }

    private void processAssociativeAnnotations(ProcessingEnvironment processingEnvironment, ElementValidator validator) {
        ReflectiveAssociation reflect;
        Optional<OneToOne> oneToOne = this.annotationOf(OneToOne.class);
        Optional<OneToMany> oneToMany = this.annotationOf(OneToMany.class);
        Optional<ManyToOne> manyToOne = this.annotationOf(ManyToOne.class);
        Optional<ManyToMany> manyToMany = this.annotationOf(ManyToMany.class);
        oneToOne = oneToOne.isPresent() ? oneToOne : this.annotationOf(javax.persistence.OneToOne.class);
        oneToMany = oneToMany.isPresent() ? oneToMany : this.annotationOf(javax.persistence.OneToMany.class);
        manyToOne = manyToOne.isPresent() ? manyToOne : this.annotationOf(javax.persistence.ManyToOne.class);
        Optional<Object> optional = manyToMany = manyToMany.isPresent() ? manyToMany : this.annotationOf(javax.persistence.ManyToMany.class);
        if (Stream.of(oneToOne, oneToMany, manyToOne, manyToMany).filter(Optional::isPresent).count() > 1L) {
            validator.error("Cannot have more than one associative annotation per field");
        }
        if (oneToOne.isPresent()) {
            this.cardinality = Cardinality.ONE_TO_ONE;
            reflect = new ReflectiveAssociation((Annotation)oneToOne.get());
            this.mappedBy = reflect.mappedBy();
            this.cascadeActions = reflect.cascade();
            if (!this.isForeignKey()) {
                this.isReadOnly = true;
                if (!this.isKey()) {
                    this.isUnique = true;
                }
            }
        }
        if (oneToMany.isPresent()) {
            this.isIterable = true;
            this.cardinality = Cardinality.ONE_TO_MANY;
            this.isReadOnly = true;
            reflect = new ReflectiveAssociation((Annotation)oneToMany.get());
            this.mappedBy = reflect.mappedBy();
            this.cascadeActions = reflect.cascade();
            this.checkIterable(validator);
            this.processOrderBy();
        }
        if (manyToOne.isPresent()) {
            this.cardinality = Cardinality.MANY_TO_ONE;
            this.isForeignKey = true;
            reflect = new ReflectiveAssociation((Annotation)manyToOne.get());
            this.cascadeActions = reflect.cascade();
            if (this.deleteAction == null) {
                this.deleteAction = ReferentialAction.CASCADE;
            }
            if (this.updateAction == null) {
                this.updateAction = ReferentialAction.CASCADE;
            }
        }
        if (manyToMany.isPresent()) {
            this.isIterable = true;
            this.cardinality = Cardinality.MANY_TO_MANY;
            reflect = new ReflectiveAssociation((Annotation)manyToMany.get());
            this.mappedBy = reflect.mappedBy();
            this.cascadeActions = reflect.cascade();
            Optional<JunctionTable> junctionTable = this.annotationOf(JunctionTable.class);
            Optional<JoinTable> joinTable = this.annotationOf(JoinTable.class);
            if (junctionTable.isPresent()) {
                Elements elements = processingEnvironment.getElementUtils();
                this.associativeDescriptor = new JunctionTableAssociation(elements, this, junctionTable.get());
            } else if (joinTable.isPresent()) {
                this.associativeDescriptor = new JoinTableAssociation(joinTable.get());
            }
            this.isReadOnly = true;
            this.checkIterable(validator);
            this.processOrderBy();
        }
        if (this.isForeignKey()) {
            Optional<? extends AnnotationMirror> mirror;
            if (this.deleteAction == ReferentialAction.SET_NULL && !this.isNullable()) {
                validator.error("Cannot SET_NULL on optional attribute", ForeignKey.class);
            }
            if ((mirror = Mirrors.findAnnotationMirror(this.element(), ForeignKey.class)).isPresent()) {
                this.referencedType = mirror.flatMap(m -> Mirrors.findAnnotationValue(m, "references")).map(value -> value.getValue().toString()).orElse(null);
            } else if (!this.typeMirror().getKind().isPrimitive()) {
                this.referencedType = this.typeMirror().toString();
            }
        }
    }

    private void checkReserved(String name, ElementValidator validator) {
        if (Stream.of(ReservedKeyword.values()).anyMatch(keyword -> keyword.toString().equalsIgnoreCase(name))) {
            validator.warning("Column or index name " + name + " may need to be escaped");
        }
    }

    private void checkIterable(ElementValidator validator) {
        if (!this.isIterable()) {
            validator.error("Many relation must be stored in an iterable type");
        }
    }

    private void processConverterAnnotation(ElementValidator validator) {
        if (this.annotationOf(Convert.class).isPresent()) {
            Optional<? extends AnnotationMirror> mirror = Mirrors.findAnnotationMirror(this.element(), Convert.class);
            this.converterType = mirror.map(Mirrors::findAnnotationValue).filter(Optional::isPresent).map(Optional::get).map(value -> value.getValue().toString()).orElse(null);
        } else if (this.annotationOf(javax.persistence.Convert.class).isPresent()) {
            Optional<? extends AnnotationMirror> mirror = Mirrors.findAnnotationMirror(this.element(), javax.persistence.Convert.class);
            this.converterType = mirror.map(m -> Mirrors.findAnnotationValue(m, "converter")).filter(Optional::isPresent).map(Optional::get).map(value -> value.getValue().toString()).orElse(null);
        }
        if (this.converterType != null && this.cardinality != null) {
            validator.warning("Cannot specify converter on association field", Convert.class);
        }
    }

    private void processOrderBy() {
        this.annotationOf(OrderBy.class).ifPresent(orderBy -> {
            this.orderByColumn = orderBy.value();
            this.orderByDirection = orderBy.order();
        });
        this.annotationOf(javax.persistence.OrderBy.class).ifPresent(orderBy -> {
            String value = orderBy.value();
            String[] parts = value.split(" ");
            if (parts.length > 0) {
                this.orderByColumn = parts[0].trim();
                if (parts.length > 1) {
                    String direction = parts[1].toUpperCase().trim();
                    try {
                        this.orderByDirection = Order.valueOf((String)direction);
                    }
                    catch (IllegalArgumentException e) {
                        this.orderByDirection = Order.ASC;
                    }
                }
            }
        });
    }

    private void cannotCombine(ElementValidator validator, Class<? extends Annotation> annotation1, Class<? extends Annotation> annotation2) {
        String first = annotation1.getSimpleName();
        String second = annotation2.getSimpleName();
        validator.error("The " + first + " annotation cannot be combined with annotation " + second, annotation2);
    }

    private String getMethodName(String override, String prefix) {
        if (Names.isEmpty(override = override.replace("\"", ""))) {
            String simpleName = Names.removeMemberPrefixes(this.element().getSimpleName());
            return Names.isEmpty(prefix) ? Names.lowerCaseFirst(simpleName) : prefix + Names.upperCaseFirst(simpleName);
        }
        return override;
    }

    @Override
    public AttributeDescriptor.Type getType() {
        return this.type;
    }

    @Override
    public TypeMirror typeMirror() {
        if (this.element().getKind().isField()) {
            return this.element().asType();
        }
        ExecutableElement executableElement = (ExecutableElement)this.element();
        return executableElement.getReturnType();
    }

    @Override
    public String fieldName() {
        if (this.element().getKind().isField()) {
            return this.element().getSimpleName().toString();
        }
        if (this.element().getKind() == ElementKind.METHOD) {
            ExecutableElement methodElement = (ExecutableElement)this.element();
            String originalName = methodElement.getSimpleName().toString();
            String name = Names.removeMethodPrefixes(originalName);
            name = Names.isAllUpper(name) ? name.toLowerCase(Locale.ROOT) : Names.lowerCaseFirst(name);
            return Names.checkReservedName(name, originalName);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getterName() {
        if (this.element().getKind().isField()) {
            String name = this.annotationOf(Naming.class).map(Naming::getter).orElse("");
            String prefix = "";
            if (this.useBeanStyleProperties()) {
                prefix = this.isBoolean ? "is" : "get";
            }
            return this.getMethodName(name, prefix);
        }
        return this.element().getSimpleName().toString();
    }

    @Override
    public String setterName() {
        if (this.element().getKind().isField()) {
            String name = this.annotationOf(Naming.class).map(Naming::setter).orElse("");
            return this.getMethodName(name, this.useBeanStyleProperties() ? "set" : "");
        }
        for (ExecutableElement element : ElementFilter.methodsIn(this.entity.element().getEnclosedElements())) {
            String property;
            List<? extends VariableElement> parameters = element.getParameters();
            if (parameters.size() != 1 || !(property = Names.removeMethodPrefixes(element.getSimpleName().toString())).toLowerCase(Locale.ROOT).equalsIgnoreCase(this.name())) continue;
            return element.getSimpleName().toString();
        }
        ExecutableElement executableElement = (ExecutableElement)this.element();
        String elementName = this.element().getSimpleName().toString();
        AccessorNamePrefix prefix = AccessorNamePrefix.fromElement(executableElement);
        switch (prefix) {
            case GET: {
                return elementName.replaceFirst("get", "set");
            }
            case IS: {
                return elementName.replaceFirst("is", "set");
            }
        }
        return elementName;
    }

    private boolean useBeanStyleProperties() {
        return this.entity.propertyNameStyle() == PropertyNameStyle.BEAN || this.entity.propertyNameStyle() == PropertyNameStyle.FLUENT_BEAN;
    }

    @Override
    public String name() {
        if (!Names.isEmpty(this.name)) {
            return this.name;
        }
        String elementName = this.element().getSimpleName().toString();
        if (this.element().getKind() == ElementKind.METHOD) {
            ExecutableElement executableElement = (ExecutableElement)this.element();
            String originalName = elementName;
            AccessorNamePrefix prefix = AccessorNamePrefix.fromElement(executableElement);
            switch (prefix) {
                case GET: {
                    elementName = elementName.replaceFirst("get", "");
                    break;
                }
                case IS: {
                    elementName = elementName.replaceFirst("is", "");
                }
            }
            elementName = Names.isAllUpper(elementName) ? elementName : Names.lowerCaseFirst(elementName);
            return Names.checkReservedName(elementName, originalName);
        }
        return elementName;
    }

    @Override
    public String collate() {
        return this.collate;
    }

    @Override
    public Integer columnLength() {
        return this.length;
    }

    @Override
    public String converterName() {
        return this.converterType;
    }

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    @Override
    public String defaultValue() {
        return this.defaultValue;
    }

    @Override
    public String definition() {
        return this.definition;
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Override
    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public boolean isGenerated() {
        return this.isGenerated;
    }

    @Override
    public boolean isIndexed() {
        return this.isIndexed;
    }

    @Override
    public boolean isIterable() {
        return this.isIterable;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public boolean isMap() {
        return this.isMap;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isVersion() {
        return this.isVersion;
    }

    @Override
    public Cardinality cardinality() {
        return this.cardinality;
    }

    @Override
    public ReferentialAction deleteAction() {
        return this.deleteAction;
    }

    @Override
    public ReferentialAction updateAction() {
        return this.updateAction;
    }

    @Override
    public Set<CascadeAction> cascadeActions() {
        EnumSet<CascadeAction> actions = EnumSet.noneOf(CascadeAction.class);
        if (this.cascadeActions != null) {
            actions.addAll(Arrays.asList(this.cascadeActions));
        }
        return actions;
    }

    @Override
    public String referencedColumn() {
        return this.referencedColumn;
    }

    @Override
    public String referencedType() {
        return this.referencedType;
    }

    @Override
    public String referencedTable() {
        return this.referencedTable;
    }

    @Override
    public String mappedBy() {
        return this.mappedBy;
    }

    @Override
    public String optionalClass() {
        return this.optionalClassName;
    }

    @Override
    public String orderBy() {
        return this.orderByColumn;
    }

    @Override
    public Order orderByDirection() {
        return this.orderByDirection;
    }

    @Override
    public Class<? extends AttributeBuilder> builderClass() {
        return this.builderClass;
    }

    @Override
    public Optional<AssociativeEntityDescriptor> associativeEntity() {
        return Optional.ofNullable(this.associativeDescriptor);
    }

    @Override
    public String toString() {
        return this.entity.typeName() + "." + this.name();
    }

    private static class ReflectiveAssociation {
        private final Annotation annotation;

        ReflectiveAssociation(Annotation annotation) {
            this.annotation = annotation;
        }

        String mappedBy() {
            try {
                return (String)this.annotation.getClass().getMethod("mappedBy", new Class[0]).invoke((Object)this.annotation, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        CascadeAction[] cascade() {
            try {
                return (CascadeAction[])this.annotation.getClass().getMethod("cascade", new Class[0]).invoke((Object)this.annotation, new Object[0]);
            }
            catch (Exception e) {
                try {
                    CascadeType[] cascadeTypes = (CascadeType[])this.annotation.getClass().getMethod("cascade", new Class[0]).invoke((Object)this.annotation, new Object[0]);
                    return ReflectiveAssociation.mapCascadeActions(cascadeTypes);
                }
                catch (Exception ee) {
                    return null;
                }
            }
        }

        private static CascadeAction[] mapCascadeActions(CascadeType[] types) {
            EnumSet<CascadeAction> actions = EnumSet.noneOf(CascadeAction.class);
            block6: for (CascadeType type : types) {
                switch (type) {
                    case ALL: {
                        actions.add(CascadeAction.SAVE);
                        actions.add(CascadeAction.DELETE);
                    }
                    case PERSIST: {
                        actions.add(CascadeAction.SAVE);
                        continue block6;
                    }
                    case MERGE: {
                        actions.add(CascadeAction.SAVE);
                        continue block6;
                    }
                    case REMOVE: {
                        actions.add(CascadeAction.DELETE);
                        continue block6;
                    }
                }
            }
            return actions.toArray(new CascadeAction[actions.size()]);
        }
    }
}

