/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.Persistable;
import io.requery.PropertyNameStyle;
import io.requery.com.squareup.javapoet.AnnotationSpec;
import io.requery.com.squareup.javapoet.ClassName;
import io.requery.com.squareup.javapoet.FieldSpec;
import io.requery.com.squareup.javapoet.MethodSpec;
import io.requery.com.squareup.javapoet.ParameterSpec;
import io.requery.com.squareup.javapoet.ParameterizedTypeName;
import io.requery.com.squareup.javapoet.TypeName;
import io.requery.com.squareup.javapoet.TypeSpec;
import io.requery.com.squareup.javapoet.WildcardTypeName;
import io.requery.meta.Attribute;
import io.requery.processor.AndroidObservableExtension;
import io.requery.processor.AndroidParcelableExtension;
import io.requery.processor.AttributeDescriptor;
import io.requery.processor.CodeGeneration;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.EntityGraph;
import io.requery.processor.EntityMetaGenerator;
import io.requery.processor.EntityPartGenerator;
import io.requery.processor.ImmutableAnnotationKind;
import io.requery.processor.ListenerDescriptor;
import io.requery.processor.Mirrors;
import io.requery.processor.Names;
import io.requery.processor.PropertyGenerationExtension;
import io.requery.processor.SourceGenerator;
import io.requery.processor.TypeGenerationExtension;
import io.requery.proxy.EntityProxy;
import io.requery.proxy.PreInsertListener;
import io.requery.proxy.PropertyState;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

class EntityGenerator
extends EntityPartGenerator
implements SourceGenerator {
    private final EntityDescriptor parent;
    private final Set<TypeGenerationExtension> typeExtensions;
    private final Set<PropertyGenerationExtension> memberExtensions;

    EntityGenerator(ProcessingEnvironment processingEnv, EntityGraph graph, EntityDescriptor entity, EntityDescriptor parent) {
        super(processingEnv, graph, entity);
        this.parent = parent;
        this.typeExtensions = new HashSet<TypeGenerationExtension>();
        this.memberExtensions = new HashSet<PropertyGenerationExtension>();
        this.typeExtensions.add(new AndroidParcelableExtension(this.types));
        AndroidObservableExtension observable = new AndroidObservableExtension(entity, processingEnv);
        this.typeExtensions.add(observable);
        this.memberExtensions.add(observable);
    }

    @Override
    public void generate() throws IOException {
        boolean metadataOnly;
        ClassName entityTypeName = this.entity.isEmbedded() ? this.nameResolver.embeddedTypeNameOf(this.entity, this.parent) : this.typeName;
        TypeSpec.Builder builder = TypeSpec.classBuilder(entityTypeName).addModifiers(Modifier.PUBLIC).addOriginatingElement(this.typeElement);
        boolean bl = metadataOnly = this.entity.isImmutable() || this.entity.isUnimplementable();
        if (this.typeElement.getKind().isInterface()) {
            builder.addSuperinterface(ClassName.get(this.typeElement));
            builder.addSuperinterface(ClassName.get(Persistable.class));
        } else if (!metadataOnly) {
            builder.superclass(ClassName.get(this.typeElement));
            builder.addSuperinterface(ClassName.get(Persistable.class));
        }
        CodeGeneration.addGeneratedAnnotation(this.processingEnv, builder);
        if (!this.entity.isEmbedded()) {
            EntityMetaGenerator meta = new EntityMetaGenerator(this.processingEnv, this.graph, this.entity);
            meta.generate(builder);
        }
        if (!metadataOnly) {
            this.generateConstructors(builder);
            this.generateMembers(builder);
            this.generateProxyMethods(builder);
            if (!this.entity.isEmbedded()) {
                this.generateEquals(builder);
                this.generateHashCode(builder);
                this.generateToString(builder);
            }
            if (this.entity.isCopyable()) {
                this.generateCopy(builder);
            }
        } else {
            builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
            this.generateMembers(builder);
            this.generateImmutableTypeBuildMethod(builder);
        }
        this.typeExtensions.forEach(extension -> extension.generate(this.entity, builder));
        CodeGeneration.writeType(this.processingEnv, this.typeName.packageName(), builder.build());
    }

    private Modifier[] generatedMemberModifiers(Modifier ... modifiers) {
        Modifier visibility = null;
        switch (this.entity.propertyVisibility()) {
            case PUBLIC: {
                visibility = Modifier.PUBLIC;
                break;
            }
            case PRIVATE: {
                if (this.entity.isEmbedded()) {
                    visibility = Modifier.PROTECTED;
                    break;
                }
                visibility = Modifier.PRIVATE;
                break;
            }
        }
        ArrayList<Modifier> list = new ArrayList<Modifier>();
        if (visibility != null) {
            list.add(visibility);
        }
        Collections.addAll(list, modifiers);
        return list.toArray(new Modifier[list.size()]);
    }

    private void generateMembers(TypeSpec.Builder builder) {
        if (!this.entity.isStateless()) {
            this.entity.attributes().stream().filter(attribute -> !attribute.isTransient()).forEach(attribute -> {
                ClassName stateType = ClassName.get(PropertyState.class);
                builder.addField(FieldSpec.builder(stateType, EntityGenerator.propertyStateFieldName(attribute), this.generatedMemberModifiers(new Modifier[0])).build());
            });
        }
        if (this.entity.isEmbedded() && !this.entity.isImmutable() && !this.entity.isUnimplementable()) {
            this.entity.attributes().stream().filter(attribute -> !attribute.isTransient()).forEach(attribute -> {
                ParameterizedTypeName attributeType = ParameterizedTypeName.get(ClassName.get(Attribute.class), this.nameResolver.typeNameOf(this.parent), this.resolveAttributeType((AttributeDescriptor)attribute));
                builder.addField(FieldSpec.builder(attributeType, EntityGenerator.attributeFieldName(attribute), this.generatedMemberModifiers(Modifier.FINAL)).build());
            });
        }
        boolean generateMembers = this.typeElement.getKind().isInterface() || !this.entity.builderType().isPresent();
        Set existingFieldNames = this.entity.attributes().stream().map(AttributeDescriptor::element).filter(it -> it.getKind() == ElementKind.FIELD).map(it -> it.getSimpleName().toString()).collect(Collectors.toSet());
        if (generateMembers) {
            for (AttributeDescriptor attributeDescriptor : this.entity.attributes()) {
                TypeName fieldName;
                Element element = attributeDescriptor.element();
                if (element.getKind() != ElementKind.METHOD) continue;
                ExecutableElement methodElement = (ExecutableElement)element;
                TypeMirror typeMirror = methodElement.getReturnType();
                if (attributeDescriptor.isIterable()) {
                    fieldName = this.parameterizedCollectionName(typeMirror);
                } else if (attributeDescriptor.isOptional()) {
                    typeMirror = EntityGenerator.tryFirstTypeArgument(attributeDescriptor.typeMirror());
                    fieldName = TypeName.get(typeMirror);
                } else {
                    fieldName = this.nameResolver.tryGeneratedTypeName(typeMirror);
                }
                if (!this.entity.isImmutable() && existingFieldNames.contains(attributeDescriptor.fieldName())) continue;
                builder.addField(FieldSpec.builder(fieldName, attributeDescriptor.fieldName(), this.generatedMemberModifiers(new Modifier[0])).build());
            }
        }
        if (this.entity.isImmutable()) {
            this.generateBuilder(builder, this.entity, "builder");
            this.entity.attributes().stream().filter(AttributeDescriptor::isEmbedded).forEach(attribute -> this.graph.embeddedDescriptorOf((AttributeDescriptor)attribute).ifPresent(embedded -> embedded.builderType().ifPresent(type -> {
                String fieldName = attribute.fieldName() + "Builder";
                this.generateBuilder(builder, (EntityDescriptor)embedded, fieldName);
            })));
        }
    }

    private void generateBuilder(TypeSpec.Builder builder, EntityDescriptor entity, String fieldName) {
        String packageName = entity.typeName().packageName();
        if (entity.builderFactoryMethod().isPresent()) {
            String returnType = entity.builderFactoryMethod().get().getReturnType().toString();
            ClassName fieldType = ClassName.get(packageName, returnType, new String[0]);
            TypeName factoryType = TypeName.get(entity.element().asType());
            String methodName = entity.builderFactoryMethod().map(method -> method.getSimpleName().toString()).orElse("");
            builder.addField(this.initializeBuilder(fieldName, fieldType, factoryType, methodName));
        } else if (ImmutableAnnotationKind.IMMUTABLE.isPresent(entity.element())) {
            String simpleName = "Immutable" + entity.element().getSimpleName().toString();
            ClassName fieldType = ClassName.get(packageName, simpleName + ".Builder", new String[0]);
            ClassName factoryType = ClassName.get(packageName, simpleName, new String[0]);
            builder.addField(this.initializeBuilder(fieldName, fieldType, factoryType, "builder"));
        } else if (entity.builderType().isPresent()) {
            TypeName builderName = this.guessAnyTypeName(packageName, entity.builderType().get());
            builder.addField(this.initializeBuilder(fieldName, builderName, builderName, null));
        }
    }

    private FieldSpec initializeBuilder(String fieldName, TypeName fieldType, TypeName builderType, String methodName) {
        FieldSpec.Builder builder = FieldSpec.builder(fieldType, fieldName, Modifier.PROTECTED);
        if (methodName != null) {
            builder.initializer("$T.$L()", builderType, methodName);
        } else {
            builder.initializer("new $T()", builderType);
        }
        return builder.build();
    }

    private void generateConstructors(TypeSpec.Builder builder) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(this.typeElement.getEnclosedElements())) {
            List<? extends VariableElement> parameters = constructor.getParameters();
            if (parameters.isEmpty()) continue;
            MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
            constructorBuilder.addModifiers(constructor.getModifiers());
            ArrayList<String> parameterNames = new ArrayList<String>();
            for (VariableElement variableElement : parameters) {
                Modifier[] modifiers = variableElement.getModifiers().toArray(new Modifier[variableElement.getModifiers().size()]);
                String parameterName = variableElement.getSimpleName().toString();
                parameterNames.add(parameterName);
                ParameterSpec.Builder parameterBuilder = ParameterSpec.builder(TypeName.get(variableElement.asType()), parameterName, modifiers);
                constructorBuilder.addParameter(parameterBuilder.build());
            }
            StringJoiner joiner = new StringJoiner(",", "(", ")");
            parameterNames.forEach(joiner::add);
            constructorBuilder.addStatement("super" + joiner.toString(), new Object[0]);
            builder.addMethod(constructorBuilder.build());
        }
    }

    private void generateProxyMethods(TypeSpec.Builder builder) {
        ClassName entityType = this.entity.isEmbedded() ? this.nameResolver.typeNameOf(this.parent) : this.typeName;
        ParameterizedTypeName proxyName = EntityGenerator.parameterizedTypeName(EntityProxy.class, entityType);
        FieldSpec.Builder proxyField = FieldSpec.builder(proxyName, "$proxy", this.generatedMemberModifiers(Modifier.FINAL, Modifier.TRANSIENT));
        if (!this.entity.isEmbedded()) {
            proxyField.initializer("new $T(this, $L)", proxyName, "$TYPE");
        }
        builder.addField(proxyField.build());
        for (AttributeDescriptor attributeDescriptor : this.entity.attributes()) {
            boolean readOnly;
            TypeName unboxedTypeName;
            boolean useField = attributeDescriptor.isTransient() || attributeDescriptor.isEmbedded();
            TypeMirror typeMirror = attributeDescriptor.typeMirror();
            if (attributeDescriptor.isIterable()) {
                unboxedTypeName = this.parameterizedCollectionName(typeMirror);
            } else if (attributeDescriptor.isOptional()) {
                unboxedTypeName = TypeName.get(EntityGenerator.tryFirstTypeArgument(attributeDescriptor.typeMirror()));
            } else if (attributeDescriptor.isEmbedded()) {
                EntityDescriptor embedded = this.graph.embeddedDescriptorOf(attributeDescriptor).orElseThrow(IllegalStateException::new);
                unboxedTypeName = this.nameResolver.embeddedTypeNameOf(embedded, this.entity);
            } else {
                unboxedTypeName = this.nameResolver.tryGeneratedTypeName(typeMirror);
            }
            String attributeName = attributeDescriptor.fieldName();
            String getterName = attributeDescriptor.getterName();
            String fieldName = Names.upperCaseUnderscore(Names.removeMemberPrefixes(attributeName));
            if (this.entity.isEmbedded()) {
                fieldName = EntityGenerator.attributeFieldName(attributeDescriptor);
            }
            MethodSpec.Builder getter = MethodSpec.methodBuilder(getterName).addModifiers(Modifier.PUBLIC).returns(attributeDescriptor.isOptional() ? TypeName.get(typeMirror) : unboxedTypeName);
            if (Mirrors.overridesMethod(this.types, this.typeElement, getterName)) {
                getter.addAnnotation(Override.class);
            }
            this.memberExtensions.forEach(extension -> extension.addToGetter(attribute2, getter));
            if (useField) {
                if (attributeDescriptor.isEmbedded()) {
                    getter.addStatement("return ($T)this.$L", unboxedTypeName, attributeName);
                } else {
                    getter.addStatement("return this.$L", attributeName);
                }
            } else if (attributeDescriptor.isOptional()) {
                String ofNullable = "ofNullable";
                if ("com.google.common.base.Optional".equals(attributeDescriptor.optionalClass())) {
                    ofNullable = "fromNullable";
                }
                getter.addStatement("return $T.$L($L.get($L))", ClassName.bestGuess(attributeDescriptor.optionalClass()), ofNullable, "$proxy", fieldName);
            } else {
                getter.addStatement("return $L.get($L)", "$proxy", fieldName);
            }
            builder.addMethod(getter.build());
            String setterName = attributeDescriptor.setterName();
            boolean bl = readOnly = this.entity.isReadOnly() || attributeDescriptor.isReadOnly();
            if (this.entity.element().getKind().isInterface() && ElementFilter.methodsIn(this.entity.element().getEnclosedElements()).stream().anyMatch(element -> element.getSimpleName().toString().equals(setterName))) {
                readOnly = false;
            }
            if (readOnly) continue;
            TypeName setTypeName = unboxedTypeName;
            boolean castType = false;
            if (setTypeName instanceof ParameterizedTypeName) {
                TypeName parameterizedName = setTypeName;
                List<TypeName> arguments = parameterizedName.typeArguments;
                ArrayList<TypeName> wildcards = new ArrayList<TypeName>();
                for (TypeName argument : arguments) {
                    if (!(argument instanceof WildcardTypeName)) {
                        Elements elements = this.processingEnv.getElementUtils();
                        TypeElement element2 = elements.getTypeElement(argument.toString());
                        if (element2 != null && element2.getKind() == ElementKind.INTERFACE) {
                            wildcards.add(WildcardTypeName.subtypeOf(argument));
                            continue;
                        }
                        wildcards.add(argument);
                        continue;
                    }
                    wildcards.add(argument);
                }
                TypeName[] array = new TypeName[wildcards.size()];
                setTypeName = ParameterizedTypeName.get(parameterizedName.rawType, wildcards.toArray(array));
                castType = true;
            }
            String paramName = Names.lowerCaseFirst(Names.removeMemberPrefixes(attributeName));
            MethodSpec.Builder setter = MethodSpec.methodBuilder(setterName).addModifiers(Modifier.PUBLIC).addParameter(setTypeName, paramName, new Modifier[0]);
            if (useField) {
                setter.addStatement("this.$L = $L", attributeName, paramName);
            } else if (castType) {
                setter.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "unchecked").build());
                setter.addStatement("$L.set($L, ($T)$L)", "$proxy", fieldName, unboxedTypeName, paramName);
            } else {
                setter.addStatement("$L.set($L, $L)", "$proxy", fieldName, paramName);
            }
            this.memberExtensions.forEach(extension -> extension.addToSetter(attribute2, setter));
            PropertyNameStyle style = this.entity.propertyNameStyle();
            if (style == PropertyNameStyle.FLUENT || style == PropertyNameStyle.FLUENT_BEAN) {
                setter.addStatement("return this", new Object[0]);
                setter.returns(this.typeName);
            }
            builder.addMethod(setter.build());
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC);
        if (this.entity.isEmbedded()) {
            constructor.addParameter(ParameterSpec.builder(proxyName, "proxy", new Modifier[0]).build());
            constructor.addStatement("this.$L = proxy", "$proxy");
            this.entity.attributes().stream().filter(attribute -> !attribute.isTransient()).forEach(attribute -> {
                ParameterizedTypeName attributeType = ParameterizedTypeName.get(ClassName.get(Attribute.class), this.nameResolver.typeNameOf(this.parent), this.resolveAttributeType((AttributeDescriptor)attribute));
                constructor.addParameter(ParameterSpec.builder(attributeType, attribute.name(), new Modifier[0]).build());
                constructor.addStatement("this.$L = $L", EntityGenerator.attributeFieldName(attribute), attribute.name());
            });
        }
        this.generateListeners(constructor);
        this.entity.attributes().stream().filter(AttributeDescriptor::isEmbedded).forEach(attribute -> this.graph.embeddedDescriptorOf((AttributeDescriptor)attribute).ifPresent(embedded -> {
            ClassName embeddedName = this.nameResolver.embeddedTypeNameOf((EntityDescriptor)embedded, this.entity);
            String format = embedded.attributes().stream().map(attr -> Names.upperCaseUnderscore(EntityGenerator.embeddedAttributeName(attribute, attr))).collect(Collectors.joining(", ", "$L = new $T($L, ", ")"));
            constructor.addStatement(format, attribute.fieldName(), embeddedName, "$proxy");
        }));
        builder.addMethod(constructor.build());
    }

    private void generateEquals(TypeSpec.Builder builder) {
        boolean overridesEquals = Mirrors.overridesMethod(this.types, this.typeElement, "equals");
        if (!overridesEquals) {
            MethodSpec.Builder equals = CodeGeneration.overridePublicMethod("equals").addParameter(TypeName.OBJECT, "obj", new Modifier[0]).returns(TypeName.BOOLEAN).addStatement("return obj instanceof $T && (($T)obj).$L.equals(this.$L)", this.typeName, this.typeName, "$proxy", "$proxy");
            builder.addMethod(equals.build());
        }
    }

    private void generateHashCode(TypeSpec.Builder builder) {
        if (!Mirrors.overridesMethod(this.types, this.typeElement, "hashCode")) {
            MethodSpec.Builder hashCode = CodeGeneration.overridePublicMethod("hashCode").returns(TypeName.INT).addStatement("return $L.hashCode()", "$proxy");
            builder.addMethod(hashCode.build());
        }
    }

    private void generateToString(TypeSpec.Builder builder) {
        if (!Mirrors.overridesMethod(this.types, this.typeElement, "toString")) {
            MethodSpec.Builder equals = CodeGeneration.overridePublicMethod("toString").returns((Type)((Object)String.class)).addStatement("return $L.toString()", "$proxy");
            builder.addMethod(equals.build());
        }
    }

    private void generateCopy(TypeSpec.Builder builder) {
        if (!Mirrors.overridesMethod(this.types, this.typeElement, "copy")) {
            MethodSpec.Builder copy = MethodSpec.methodBuilder("copy").addModifiers(Modifier.PUBLIC).returns(this.typeName).addStatement("return $L.copy()", "$proxy");
            builder.addMethod(copy.build());
        }
    }

    private void generateListeners(MethodSpec.Builder constructor) {
        for (Map.Entry<Element, ? extends ListenerDescriptor> entry : this.entity.listeners().entrySet()) {
            for (Annotation annotation : entry.getValue().listenerAnnotations()) {
                String annotationName = annotation.annotationType().getSimpleName().replace("Persist", "Insert").replace("Remove", "Delete");
                String methodName = Names.lowerCaseFirst(annotationName);
                TypeElement listener = this.elements.getTypeElement(PreInsertListener.class.getCanonicalName());
                PackageElement packageElement = this.elements.getPackageOf(listener);
                String packageName = packageElement.getQualifiedName().toString();
                ClassName listenerName = ClassName.get(packageName, annotationName + "Listener", new String[0]);
                ParameterizedTypeName getterType = ParameterizedTypeName.get(listenerName, this.typeName);
                TypeSpec.Builder listenerBuilder = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(getterType).addMethod(CodeGeneration.overridePublicMethod(methodName).addParameter(this.typeName, "entity", new Modifier[0]).addStatement("$L()", entry.getKey().getSimpleName()).build());
                constructor.addStatement("$L.modifyListeners().add$L($L)", "$proxy", annotationName + "Listener", listenerBuilder.build());
            }
        }
    }

    private void generateImmutableTypeBuildMethod(TypeSpec.Builder builder) {
        if (this.entity.isImmutable() && !this.entity.builderType().isPresent() && this.entity.factoryMethod().isPresent()) {
            String methodName = this.entity.factoryMethod().map(element -> element.getSimpleName().toString()).orElse("");
            List<String> argumentNames = this.entity.factoryArguments();
            StringJoiner joiner = new StringJoiner(",");
            argumentNames.forEach(name -> joiner.add("$L"));
            MethodSpec.Builder build = MethodSpec.methodBuilder("build").returns(ClassName.get(this.entity.element()));
            if (methodName.equals("<init>")) {
                Object[] args = new Object[1 + argumentNames.size()];
                args[0] = ClassName.get(this.entity.element());
                System.arraycopy(argumentNames.toArray(), 0, args, 1, argumentNames.size());
                build.addStatement("return new $T(" + joiner.toString() + ")", args).build();
            } else {
                Object[] args = new Object[2 + argumentNames.size()];
                args[0] = ClassName.get(this.entity.element());
                args[1] = methodName;
                System.arraycopy(argumentNames.toArray(), 0, args, 2, argumentNames.size());
                build.addStatement("return $T.$L(" + joiner.toString() + ")", args).build();
            }
            builder.addMethod(build.build());
        }
    }
}

