/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.com.squareup.javapoet.ClassName;
import io.requery.com.squareup.javapoet.TypeName;
import io.requery.processor.AssociativeEntityDescriptor;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.EntityGraph;
import io.requery.processor.Names;
import java.util.Optional;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

class EntityNameResolver {
    private final EntityGraph graph;

    EntityNameResolver(EntityGraph graph) {
        this.graph = graph;
    }

    ClassName typeNameOf(EntityDescriptor type) {
        return ClassName.bestGuess(type.typeName().toString());
    }

    ClassName embeddedTypeNameOf(EntityDescriptor embedded, EntityDescriptor parent) {
        String className = parent.typeName().className() + "_" + embedded.typeName().className();
        return ClassName.get(parent.typeName().packageName(), className, new String[0]);
    }

    TypeName tryGeneratedTypeName(TypeMirror typeMirror) {
        Optional<ClassName> name = this.generatedTypeNameOf(typeMirror);
        return name.isPresent() ? (TypeName)name.get() : TypeName.get(typeMirror);
    }

    Optional<ClassName> generatedTypeNameOf(TypeMirror typeMirror) {
        return this.graph.entities().stream().filter(entity -> entity.typeName().className().equals(typeMirror.toString())).map(this::typeNameOf).findFirst();
    }

    Optional<ClassName> generatedTypeNameOf(TypeElement typeElement) {
        return this.graph.entities().stream().filter(entity -> entity.element().getQualifiedName().equals(typeElement.getQualifiedName())).map(this::typeNameOf).findFirst();
    }

    ClassName joinEntityName(AssociativeEntityDescriptor descriptor, EntityDescriptor a, EntityDescriptor b) {
        if (descriptor.type().isPresent()) {
            return descriptor.type().flatMap(this::generatedTypeNameOf).orElse(ClassName.bestGuess(descriptor.name()));
        }
        String className = Names.isEmpty(descriptor.name()) ? a.typeName().className() + "_" + b.typeName().className() : Names.upperCaseFirst(descriptor.name());
        return ClassName.get(a.typeName().packageName(), className, new String[0]);
    }
}

