/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.Embedded;
import io.requery.Entity;
import io.requery.Factory;
import io.requery.PropertyNameStyle;
import io.requery.PropertyVisibility;
import io.requery.ReadOnly;
import io.requery.Table;
import io.requery.Transient;
import io.requery.View;
import io.requery.processor.AttributeDescriptor;
import io.requery.processor.AttributeMember;
import io.requery.processor.BaseProcessableElement;
import io.requery.processor.ElementValidator;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.EntityElement;
import io.requery.processor.ImmutableAnnotationKind;
import io.requery.processor.ListenerAnnotations;
import io.requery.processor.ListenerDescriptor;
import io.requery.processor.ListenerMethod;
import io.requery.processor.Mirrors;
import io.requery.processor.Names;
import io.requery.processor.ProcessableElement;
import io.requery.processor.QualifiedName;
import io.requery.processor.ReservedKeyword;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.persistence.Cacheable;
import javax.persistence.Embeddable;
import javax.persistence.Index;
import javax.tools.Diagnostic;

class EntityType
extends BaseProcessableElement<TypeElement>
implements EntityElement {
    private final ProcessingEnvironment processingEnvironment;
    private final Set<AttributeDescriptor> attributes;
    private final Map<Element, ListenerMethod> listeners;

    EntityType(ProcessingEnvironment processingEnvironment, TypeElement typeElement) {
        super(typeElement);
        this.processingEnvironment = processingEnvironment;
        this.attributes = new LinkedHashSet<AttributeDescriptor>();
        this.listeners = new LinkedHashMap<Element, ListenerMethod>();
    }

    @Override
    public Set<ElementValidator> process(ProcessingEnvironment processingEnvironment) {
        Set<Object> elements;
        if (((TypeElement)this.element()).getKind().isInterface() || this.isImmutable() || this.isUnimplementable()) {
            ElementFilter.methodsIn(((TypeElement)this.element()).getEnclosedElements()).stream().filter(this::isMethodProcessable).forEach(this::computeAttribute);
        } else {
            elements = ElementFilter.fieldsIn(((TypeElement)this.element()).getEnclosedElements()).stream().filter(element -> !element.getModifiers().contains((Object)Modifier.PRIVATE) && !element.getModifiers().contains((Object)Modifier.STATIC) && (!element.getModifiers().contains((Object)Modifier.FINAL) || this.isImmutable())).collect(Collectors.toSet());
            if (elements.isEmpty()) {
                ElementFilter.methodsIn(((TypeElement)this.element()).getEnclosedElements()).stream().filter(this::isMethodProcessable).forEach(this::computeAttribute);
            } else {
                elements.forEach(this::computeAttribute);
            }
        }
        ElementFilter.methodsIn(((TypeElement)this.element()).getEnclosedElements()).forEach(element -> ListenerAnnotations.all().forEach(annotation -> {
            if (element.getAnnotation(annotation) != null) {
                ListenerMethod listener = this.listeners.computeIfAbsent((Element)element, key -> new ListenerMethod((ExecutableElement)element));
                listener.annotations().put((Class<Annotation>)annotation, (Annotation)element.getAnnotation(annotation));
            }
        }));
        elements = new LinkedHashSet();
        this.attributes().forEach(attribute -> elements.add((ProcessableElement)((Object)attribute)));
        elements.addAll(this.listeners.values());
        LinkedHashSet<ElementValidator> validations = new LinkedHashSet<ElementValidator>();
        elements.forEach(element -> validations.addAll(element.process(processingEnvironment)));
        ElementValidator validator = new ElementValidator((Element)this.element(), processingEnvironment);
        Entity entity = this.annotationOf(Entity.class).orElse(null);
        if (entity != null && !Names.isEmpty(entity.name()) && !SourceVersion.isIdentifier(entity.name())) {
            validator.error("Invalid class identifier " + entity.name(), Entity.class);
        }
        if (((TypeElement)this.element()).getNestingKind() == NestingKind.ANONYMOUS) {
            validator.error("Entity annotation cannot be applied to anonymous class");
        }
        if (((TypeElement)this.element()).getKind() == ElementKind.ENUM) {
            validator.error("Entity annotation cannot be applied to an enum class");
        }
        if (this.attributes.isEmpty()) {
            validator.warning("Entity contains no attributes");
        }
        if (!this.isReadOnly() && !this.isEmbedded() && this.attributes.size() == 1 && this.attributes.iterator().next().isGenerated()) {
            validator.warning("Entity contains only a single generated attribute may fail to persist");
        }
        this.checkReserved(this.tableName(), validator);
        validations.add(validator);
        return validations;
    }

    private boolean isMethodProcessable(ExecutableElement element) {
        if (!(this.isUnimplementable() || !((TypeElement)this.element()).getKind().isClass() || !this.isImmutable() || element.getModifiers().contains((Object)Modifier.ABSTRACT) || ImmutableAnnotationKind.of(this.element()).isPresent() && ImmutableAnnotationKind.of(this.element()).get().hasAnyMemberAnnotation(element))) {
            return false;
        }
        String name = element.getSimpleName().toString();
        if (this.isUnimplementable() && name.startsWith("component") && name.length() > "component".length()) {
            return false;
        }
        TypeMirror type = element.getReturnType();
        boolean isInterface = ((TypeElement)this.element()).getKind().isInterface();
        boolean isTransient = Mirrors.findAnnotationMirror((Element)element, Transient.class).isPresent();
        return !(type.getKind() == TypeKind.VOID || !element.getParameters().isEmpty() || !this.isImmutable() && !isInterface && element.getModifiers().contains((Object)Modifier.FINAL) || this.isImmutable() && type.equals(((TypeElement)this.element()).asType()) || type.equals(this.builderType().orElse(null)) || element.getModifiers().contains((Object)Modifier.STATIC) || element.getModifiers().contains((Object)Modifier.DEFAULT) || isTransient && !isInterface || name.equals("toString") || name.equals("hashCode"));
    }

    @Override
    public void addAnnotationElement(TypeElement annotationElement, Element annotatedElement) {
        Class<Annotation> type;
        String qualifiedName = annotationElement.getQualifiedName().toString();
        try {
            type = Class.forName(qualifiedName).asSubclass(Annotation.class);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        switch (annotatedElement.getKind()) {
            case CLASS: 
            case INTERFACE: {
                this.annotations().put(type, annotatedElement.getAnnotation(type));
                break;
            }
            case FIELD: {
                if (annotatedElement.getModifiers().contains((Object)Modifier.STATIC) || annotatedElement.getModifiers().contains((Object)Modifier.FINAL)) {
                    String packageName = Entity.class.getPackage().getName();
                    if (!annotationElement.getQualifiedName().toString().startsWith(packageName)) break;
                    this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, annotationElement.getQualifiedName() + " not applicable to static or final member", annotatedElement);
                    break;
                }
                VariableElement element = (VariableElement)annotatedElement;
                Optional<AttributeMember> attribute = this.computeAttribute(element);
                Annotation annotation = annotatedElement.getAnnotation(type);
                attribute.ifPresent(a -> a.annotations().put(type, annotation));
                break;
            }
            case METHOD: {
                ExecutableElement element = (ExecutableElement)annotatedElement;
                Annotation annotation = annotatedElement.getAnnotation(type);
                if (ListenerAnnotations.all().anyMatch(a -> a.equals(type))) {
                    ListenerMethod listener = this.listeners.computeIfAbsent(element, key -> new ListenerMethod(element));
                    listener.annotations().put(type, annotation);
                    break;
                }
                if (!this.isMethodProcessable(element)) break;
                Optional<AttributeMember> attribute = this.computeAttribute(element);
                attribute.ifPresent(a -> a.annotations().put(type, annotation));
            }
        }
    }

    private Optional<AttributeMember> computeAttribute(Element element) {
        AttributeMember attribute = new AttributeMember(element, this);
        if (this.attributes.stream().noneMatch(a -> a.name().equals(attribute.name()))) {
            this.attributes.add(attribute);
            return Optional.of(attribute);
        }
        return Optional.empty();
    }

    @Override
    public void merge(EntityDescriptor from) {
        from.attributes().forEach(entry -> {
            if (this.attributes.stream().noneMatch(attribute -> attribute.name().equals(entry.name()))) {
                this.attributes.add(new AttributeMember(entry.element(), this));
            }
        });
        from.listeners().entrySet().stream().filter(entry -> entry.getValue() instanceof ListenerMethod).forEach(entry -> {
            ListenerMethod method = (ListenerMethod)entry.getValue();
            if (this.listeners.values().stream().noneMatch(listener -> ((ExecutableElement)listener.element()).getSimpleName().equals(((ExecutableElement)method.element()).getSimpleName()))) {
                this.listeners.put((Element)entry.getKey(), method);
            }
        });
    }

    @Override
    public boolean generatesAdditionalTypes() {
        return this.attributes.stream().anyMatch(member -> member.associativeEntity().isPresent());
    }

    private void checkReserved(String name, ElementValidator validator) {
        if (Stream.of(ReservedKeyword.values()).anyMatch(keyword -> keyword.toString().equalsIgnoreCase(name))) {
            validator.warning("Table or view name " + name + " may need to be escaped");
        }
    }

    @Override
    public Collection<? extends AttributeDescriptor> attributes() {
        return this.attributes;
    }

    @Override
    public Map<Element, ? extends ListenerDescriptor> listeners() {
        return this.listeners;
    }

    @Override
    public String modelName() {
        if (Mirrors.findAnnotationMirror(this.element(), Entity.class).isPresent()) {
            return Mirrors.findAnnotationMirror(this.element(), Entity.class).flatMap(mirror -> Mirrors.findAnnotationValue(mirror, "model")).map(value -> value.getValue().toString()).filter(name -> !Names.isEmpty(name)).orElse("default");
        }
        if (Mirrors.findAnnotationMirror(this.element(), javax.persistence.Entity.class).isPresent()) {
            Elements elements = this.processingEnvironment.getElementUtils();
            Name packageName = elements.getPackageOf((Element)this.element()).getQualifiedName();
            String[] parts = packageName.toString().split("\\.");
            return parts[parts.length - 1];
        }
        return "";
    }

    @Override
    public QualifiedName typeName() {
        String entityName = Stream.of(Mirrors.findAnnotationMirror(this.element(), Entity.class), Mirrors.findAnnotationMirror(this.element(), javax.persistence.Entity.class)).filter(Optional::isPresent).map(Optional::get).map(mirror -> Mirrors.findAnnotationValue(mirror, "name")).filter(Optional::isPresent).map(Optional::get).map(value -> value.getValue().toString()).filter(name -> !Names.isEmpty(name)).findAny().orElse("");
        Elements elements = this.processingEnvironment.getElementUtils();
        String packageName = elements.getPackageOf((Element)this.element()).getQualifiedName().toString();
        if (!Names.isEmpty(entityName)) {
            return new QualifiedName(packageName, entityName);
        }
        String typeName = ((TypeElement)this.element()).getSimpleName().toString();
        if (((TypeElement)this.element()).getKind().isInterface()) {
            entityName = typeName.startsWith("I") && Character.isUpperCase(typeName.charAt(1)) ? typeName.substring(1) : typeName + "Entity";
        } else {
            entityName = Names.removeClassPrefixes(typeName);
            if (entityName.equals(typeName)) {
                entityName = typeName + (this.isImmutable() || this.isUnimplementable() ? "Type" : "Entity");
            }
        }
        return new QualifiedName(packageName, entityName);
    }

    @Override
    public PropertyNameStyle propertyNameStyle() {
        return this.annotationOf(Entity.class).map(Entity::propertyNameStyle).orElse(PropertyNameStyle.BEAN);
    }

    @Override
    public PropertyVisibility propertyVisibility() {
        return this.annotationOf(Entity.class).map(Entity::propertyVisibility).orElse(PropertyVisibility.PRIVATE);
    }

    @Override
    public String tableName() {
        return this.annotationOf(Table.class).map(Table::name).orElse(this.annotationOf(javax.persistence.Table.class).map(javax.persistence.Table::name).orElse(this.annotationOf(View.class).map(View::name).orElse(((TypeElement)this.element()).getKind().isInterface() || this.isImmutable() ? ((TypeElement)this.element()).getSimpleName().toString() : Names.removeClassPrefixes(((TypeElement)this.element()).getSimpleName()))));
    }

    @Override
    public String[] tableAttributes() {
        return this.annotationOf(Table.class).map(Table::createAttributes).orElse(new String[0]);
    }

    @Override
    public String[] tableUniqueIndexes() {
        if (this.annotationOf(javax.persistence.Table.class).isPresent()) {
            Index[] indexes = this.annotationOf(javax.persistence.Table.class).map(javax.persistence.Table::indexes).orElse(new Index[0]);
            Set<String> names = Stream.of(indexes).filter(Index::unique).map(Index::name).collect(Collectors.toSet());
            return names.toArray(new String[names.size()]);
        }
        return this.annotationOf(Table.class).map(Table::uniqueIndexes).orElse(new String[0]);
    }

    @Override
    public boolean isCacheable() {
        return this.annotationOf(Entity.class).map(Entity::cacheable).orElse(this.annotationOf(Cacheable.class).map(Cacheable::value).orElse(true));
    }

    @Override
    public boolean isCopyable() {
        return this.annotationOf(Entity.class).map(Entity::copyable).orElse(false);
    }

    @Override
    public boolean isImmutable() {
        return ImmutableAnnotationKind.of(this.element()).isPresent() || this.isUnimplementable() || this.annotationOf(Entity.class).map(Entity::immutable).orElse(false) != false;
    }

    @Override
    public boolean isReadOnly() {
        return this.annotationOf(ReadOnly.class).isPresent();
    }

    @Override
    public boolean isStateless() {
        return this.isImmutable() || this.isUnimplementable() || this.annotationOf(Entity.class).map(Entity::stateless).orElse(false) != false;
    }

    @Override
    public boolean isView() {
        return this.annotationOf(View.class).isPresent();
    }

    @Override
    public boolean isUnimplementable() {
        boolean extendable = this.annotationOf(Entity.class).map(Entity::extendable).orElse(true);
        return !extendable || ((TypeElement)this.element()).getKind().isClass() && ((TypeElement)this.element()).getModifiers().contains((Object)Modifier.FINAL);
    }

    @Override
    public boolean isEmbedded() {
        return this.annotationOf(Embedded.class).isPresent() || this.annotationOf(Embeddable.class).isPresent();
    }

    @Override
    public Optional<TypeMirror> builderType() {
        Optional<Entity> entityAnnotation = this.annotationOf(Entity.class);
        if (entityAnnotation.isPresent()) {
            Entity entity = entityAnnotation.get();
            Elements elements = this.processingEnvironment.getElementUtils();
            TypeMirror mirror = null;
            try {
                Class builderClass = entity.builder();
                if (builderClass != Void.TYPE) {
                    mirror = elements.getTypeElement(builderClass.getName()).asType();
                }
            }
            catch (MirroredTypeException typeException) {
                mirror = typeException.getTypeMirror();
            }
            if (mirror != null && mirror.getKind() != TypeKind.VOID) {
                return Optional.of(mirror);
            }
        }
        if (this.builderFactoryMethod().isPresent()) {
            return Optional.of(this.builderFactoryMethod().get().getReturnType());
        }
        return ElementFilter.typesIn(((TypeElement)this.element()).getEnclosedElements()).stream().filter(element -> element.getSimpleName().toString().contains("Builder")).map(Element::asType).filter(Objects::nonNull).filter(type -> type.getKind() != TypeKind.VOID).findFirst();
    }

    @Override
    public Optional<ExecutableElement> builderFactoryMethod() {
        return ElementFilter.methodsIn(((TypeElement)this.element()).getEnclosedElements()).stream().filter(element -> element.getModifiers().contains((Object)Modifier.STATIC)).filter(element -> element.getSimpleName().toString().equals("builder")).findFirst();
    }

    @Override
    public Optional<ExecutableElement> factoryMethod() {
        Optional<ExecutableElement> staticFactory = ElementFilter.methodsIn(((TypeElement)this.element()).getEnclosedElements()).stream().filter(element -> element.getModifiers().contains((Object)Modifier.STATIC)).filter(element -> element.getSimpleName().toString().equalsIgnoreCase("create")).filter(element -> element.getParameters().size() > 0).filter(element -> element.getReturnType().equals(((TypeElement)this.element()).asType())).findAny();
        Optional<ExecutableElement> constructor = ElementFilter.constructorsIn(((TypeElement)this.element()).getEnclosedElements()).stream().filter(element -> element.getParameters().size() > 0).findAny();
        return staticFactory.isPresent() ? staticFactory : constructor;
    }

    @Override
    public List<String> factoryArguments() {
        ArrayList<String> names = new ArrayList<String>();
        ExecutableElement method = this.factoryMethod().orElseThrow(IllegalStateException::new);
        LinkedHashMap map = new LinkedHashMap();
        this.attributes.forEach(attribute -> map.put(attribute.element(), attribute));
        for (VariableElement variableElement : method.getParameters()) {
            Element matched = null;
            for (Map.Entry entry : map.entrySet()) {
                AttributeDescriptor attribute2 = (AttributeDescriptor)entry.getValue();
                String fieldName = attribute2.fieldName();
                if (!fieldName.equalsIgnoreCase(variableElement.getSimpleName().toString())) continue;
                names.add(fieldName);
                matched = (Element)entry.getKey();
            }
            if (matched == null) continue;
            map.remove(matched);
        }
        if (names.isEmpty()) {
            if (this.isUnimplementable()) {
                ElementFilter.methodsIn(((TypeElement)this.element()).getEnclosedElements()).stream().filter(this::isMethodProcessable).forEach(getter -> names.addAll(map.entrySet().stream().filter(entry -> ((Element)entry.getKey()).equals(getter)).map(entry -> ((AttributeDescriptor)entry.getValue()).fieldName()).collect(Collectors.toList())));
            } else {
                for (Map.Entry entry : map.entrySet()) {
                    names.add(0, ((AttributeDescriptor)entry.getValue()).fieldName());
                }
            }
        }
        return names;
    }

    @Override
    public String classFactoryName() {
        return Mirrors.findAnnotationMirror(this.element(), Factory.class).flatMap(Mirrors::findAnnotationValue).map(value -> value.getValue().toString()).orElse(null);
    }
}

