/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.Column;
import io.requery.ForeignKey;
import io.requery.JunctionTable;
import io.requery.ReferentialAction;
import io.requery.processor.AssociativeEntityDescriptor;
import io.requery.processor.AssociativeReference;
import io.requery.processor.AttributeMember;
import io.requery.processor.Mirrors;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

class JunctionTableAssociation
implements AssociativeEntityDescriptor {
    private final JunctionTable table;
    private final Set<AssociativeReference> columns;
    private final TypeMirror typeMirror;

    JunctionTableAssociation(Elements elements, AttributeMember member, JunctionTable table) {
        TypeMirror mirror;
        block7: {
            this.table = table;
            this.columns = new LinkedHashSet<AssociativeReference>();
            Optional columnValues = Mirrors.findAnnotationMirror(member.element(), JunctionTable.class).flatMap(m -> Mirrors.findAnnotationValue(m, "columns"));
            for (Column column : table.columns()) {
                ReferentialAction deleteAction = ReferentialAction.CASCADE;
                ReferentialAction updateAction = ReferentialAction.CASCADE;
                TypeElement referenceType = null;
                String referencedColumn = null;
                if (column.foreignKey().length > 0) {
                    ForeignKey key = column.foreignKey()[0];
                    deleteAction = key.delete();
                    updateAction = key.update();
                    if (columnValues.isPresent()) {
                        Optional<AnnotationValue> keyValue;
                        List mirrors = (List)((AnnotationValue)columnValues.get()).getValue();
                        AnnotationMirror mirror2 = null;
                        for (Object m2 : mirrors) {
                            String name = Mirrors.findAnnotationValue((AnnotationMirror)m2, "name").map(AnnotationValue::getValue).map(Object::toString).orElse(null);
                            if (!column.name().equals(name)) continue;
                            mirror2 = (AnnotationMirror)m2;
                            break;
                        }
                        if (mirror2 != null && (keyValue = Mirrors.findAnnotationValue(mirror2, "foreignKey")).isPresent()) {
                            List children = (List)keyValue.get().getValue();
                            AnnotationMirror keyMirror = (AnnotationMirror)children.get(0);
                            referenceType = Mirrors.findAnnotationValue(keyMirror, "references").map(value -> elements.getTypeElement(value.getValue().toString())).orElse(null);
                            referencedColumn = Mirrors.findAnnotationValue(keyMirror, "referencedColumn").map(value -> value.getValue().toString()).orElse(null);
                        }
                    }
                }
                this.columns.add(new AssociativeReference(column.name(), referenceType, referencedColumn, deleteAction, updateAction));
            }
            mirror = null;
            try {
                table.type();
            }
            catch (MirroredTypeException e) {
                if (e.getTypeMirror().toString().equals("void")) break block7;
                mirror = e.getTypeMirror();
            }
        }
        this.typeMirror = mirror;
    }

    @Override
    public String name() {
        return this.table.name();
    }

    @Override
    public Set<AssociativeReference> columns() {
        return this.columns;
    }

    @Override
    public Optional<TypeMirror> type() {
        return Optional.ofNullable(this.typeMirror);
    }
}

