/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.com.squareup.javapoet.ClassName;
import io.requery.com.squareup.javapoet.CodeBlock;
import io.requery.com.squareup.javapoet.FieldSpec;
import io.requery.com.squareup.javapoet.MethodSpec;
import io.requery.com.squareup.javapoet.TypeSpec;
import io.requery.meta.EntityModel;
import io.requery.meta.EntityModelBuilder;
import io.requery.processor.CodeGeneration;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.SourceGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

class ModelGenerator
implements SourceGenerator {
    private final String packageName;
    private final ProcessingEnvironment processingEnvironment;
    private final Collection<? extends EntityDescriptor> entities;

    ModelGenerator(ProcessingEnvironment processingEnvironment, String packageName, Collection<? extends EntityDescriptor> entities) {
        this.processingEnvironment = processingEnvironment;
        this.packageName = packageName;
        this.entities = entities;
    }

    @Override
    public void generate() throws IOException {
        ClassName typeName = ClassName.get(this.packageName, "Models", new String[0]);
        TypeSpec.Builder type = TypeSpec.classBuilder(typeName).addModifiers(Modifier.PUBLIC).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        CodeGeneration.addGeneratedAnnotation(this.processingEnvironment, type);
        HashMap models = new HashMap();
        this.entities.forEach(entity -> models.computeIfAbsent(entity.modelName(), key -> new HashSet()).add(entity));
        for (String model : models.keySet()) {
            Set types = (Set)models.get(model);
            FieldSpec.Builder field = FieldSpec.builder(ClassName.get(EntityModel.class), model.toUpperCase(), Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
            CodeBlock.Builder fieldType = CodeBlock.builder();
            fieldType.add("new $T($S)\n", ClassName.get(EntityModelBuilder.class), model);
            types.forEach(e -> fieldType.add(".addType($T.$L)\n", ClassName.bestGuess(e.typeName().toString()), "$TYPE"));
            fieldType.add(".build()", new Object[0]);
            field.initializer("$L", fieldType.build());
            type.addField(field.build());
        }
        CodeGeneration.writeType(this.processingEnvironment, typeName.packageName(), type.build());
    }
}

