/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.com.squareup.javapoet.ClassName;
import io.requery.com.squareup.javapoet.MethodSpec;
import io.requery.com.squareup.javapoet.TypeSpec;
import io.requery.processor.AttributeDescriptor;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.Mirrors;
import io.requery.processor.Names;
import io.requery.processor.PropertyGenerationExtension;
import io.requery.processor.TypeGenerationExtension;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

class AndroidObservableExtension
implements TypeGenerationExtension,
PropertyGenerationExtension {
    private static final String BINDING_PACKAGE = "androidx.databinding";
    private static final String MODULE_PACKAGE_OPTION = "android.databinding.modulePackage";
    private final EntityDescriptor entity;
    private final ProcessingEnvironment processingEnvironment;
    private final boolean observable;
    private String modulePackage;

    AndroidObservableExtension(EntityDescriptor entity, ProcessingEnvironment processingEnvironment) {
        this.entity = entity;
        this.processingEnvironment = processingEnvironment;
        this.observable = this.isObservable();
        this.modulePackage = processingEnvironment.getOptions().get(MODULE_PACKAGE_OPTION);
        if (this.modulePackage == null) {
            for (Map.Entry<String, String> entry : processingEnvironment.getOptions().entrySet()) {
                if (!entry.getKey().endsWith("databinding.modulePackage")) continue;
                this.modulePackage = entry.getValue();
                break;
            }
        }
    }

    private boolean isObservable() {
        String[] types = new String[]{"androidx.databinding.BaseObservable", "androidx.databinding.Observable"};
        TypeElement element = this.entity.element();
        return Arrays.stream(types).anyMatch(name -> Mirrors.isInstance(this.processingEnvironment.getTypeUtils(), element, name));
    }

    private boolean isBindable(AttributeDescriptor descriptor) {
        Element element = descriptor.element();
        return Mirrors.findAnnotationMirror(element, "androidx.databinding.Bindable").isPresent();
    }

    @Override
    public void generate(EntityDescriptor entity, TypeSpec.Builder builder) {
        if (this.isObservable() && entity.element().getKind().isInterface()) {
            builder.superclass(ClassName.get(BINDING_PACKAGE, "BaseObservable", new String[0]));
        }
    }

    @Override
    public void addToGetter(AttributeDescriptor member, MethodSpec.Builder builder) {
        if (this.observable && this.isBindable(member)) {
            builder.addAnnotation(ClassName.get(BINDING_PACKAGE, "Bindable", new String[0]));
        }
    }

    @Override
    public void addToSetter(AttributeDescriptor member, MethodSpec.Builder builder) {
        Optional<String> modulePackage;
        if (!this.observable || !this.isBindable(member)) {
            return;
        }
        Elements elements = this.processingEnvironment.getElementUtils();
        String bindingInfo = "androidx.databinding.layouts.DataBindingInfo";
        TypeElement dataBindingType = elements.getTypeElement(bindingInfo);
        ClassName BRclass = null;
        if (!Names.isEmpty(this.modulePackage)) {
            BRclass = ClassName.get(this.modulePackage, "BR", new String[0]);
        } else if (dataBindingType != null && (modulePackage = Mirrors.findAnnotationMirror((Element)dataBindingType, "androidx.databinding.BindingBuildInfo").map(mirror -> Mirrors.findAnnotationValue(mirror, "modulePackage")).filter(Optional::isPresent).map(Optional::get).map(AnnotationValue::toString)).isPresent()) {
            BRclass = ClassName.get(modulePackage.get().replaceAll("\"", ""), "BR", new String[0]);
        }
        if (BRclass == null) {
            PackageElement packageElement = elements.getPackageOf(this.entity.element());
            String packageName = packageElement.getQualifiedName().toString();
            BRclass = ClassName.get(packageName, "BR", new String[0]);
        }
        String propertyName = member.setterName().replaceFirst("set", "");
        propertyName = Names.lowerCaseFirst(propertyName);
        builder.addStatement("notifyPropertyChanged($L.$L)", BRclass, propertyName);
    }
}

