/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.com.squareup.javapoet.ArrayTypeName;
import io.requery.com.squareup.javapoet.ClassName;
import io.requery.com.squareup.javapoet.FieldSpec;
import io.requery.com.squareup.javapoet.ParameterSpec;
import io.requery.com.squareup.javapoet.ParameterizedTypeName;
import io.requery.com.squareup.javapoet.TypeName;
import io.requery.com.squareup.javapoet.TypeSpec;
import io.requery.processor.CodeGeneration;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.Mirrors;
import io.requery.processor.TypeGenerationExtension;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;

class AndroidParcelableExtension
implements TypeGenerationExtension {
    private static final String PACKAGE_ANDROID_OS = "android.os";
    private static final String PACKAGE_PARCELER = "io.requery.android";
    private final Types types;

    AndroidParcelableExtension(Types types) {
        this.types = types;
    }

    @Override
    public void generate(EntityDescriptor entity, TypeSpec.Builder builder) {
        TypeElement typeElement = entity.element();
        if (entity.isImmutable() || !Mirrors.isInstance(this.types, typeElement, "android.os.Parcelable") || Mirrors.overridesMethod(this.types, typeElement, "writeToParcel")) {
            return;
        }
        ClassName className = ClassName.bestGuess(entity.typeName().toString());
        ParameterizedTypeName creatorType = ParameterizedTypeName.get(ClassName.get(PACKAGE_ANDROID_OS, "Parcelable.Creator", new String[0]), className);
        ClassName parcelName = ClassName.get(PACKAGE_ANDROID_OS, "Parcel", new String[0]);
        ClassName parcelableName = ClassName.get(PACKAGE_ANDROID_OS, "Parcelable", new String[0]);
        builder.addSuperinterface(parcelableName);
        TypeSpec.Builder creatorBuilder = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(creatorType).addMethod(CodeGeneration.overridePublicMethod("createFromParcel").addParameter(ParameterSpec.builder(parcelName, "source", new Modifier[0]).build()).addStatement("return PARCELER.readFromParcel(source)", new Object[0]).returns(className).build()).addMethod(CodeGeneration.overridePublicMethod("newArray").addParameter(TypeName.INT, "size", new Modifier[0]).addStatement("return new $T[size]", className).returns(ArrayTypeName.of(className)).build());
        builder.addField(FieldSpec.builder(creatorType, "CREATOR", Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("$L", creatorBuilder.build()).build());
        builder.addMethod(CodeGeneration.overridePublicMethod("describeContents").returns(TypeName.INT).addStatement("return 0", new Object[0]).build());
        builder.addMethod(CodeGeneration.overridePublicMethod("writeToParcel").returns(TypeName.VOID).addParameter(parcelName, "dest", new Modifier[0]).addParameter(TypeName.INT, "flags", new Modifier[0]).addStatement("PARCELER.writeToParcel(this, dest)", new Object[0]).build());
        ParameterizedTypeName parcelerType = ParameterizedTypeName.get(ClassName.get(PACKAGE_PARCELER, "EntityParceler", new String[0]), className);
        builder.addField(FieldSpec.builder(parcelerType, "PARCELER", Modifier.STATIC, Modifier.FINAL).initializer("new $T($L)", parcelerType, "$TYPE").build());
    }
}

