/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.processor.ProcessableElement;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.Element;

abstract class BaseProcessableElement<E extends Element>
implements ProcessableElement<E> {
    private final E element;
    private final Map<Class<? extends Annotation>, Annotation> annotations;

    BaseProcessableElement(E element) {
        this.element = (Element)Objects.requireNonNull(element);
        this.annotations = new HashMap<Class<? extends Annotation>, Annotation>();
    }

    @Override
    public E element() {
        return this.element;
    }

    @Override
    public Map<Class<? extends Annotation>, Annotation> annotations() {
        return this.annotations;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProcessableElement) {
            ProcessableElement other = (ProcessableElement)obj;
            return this.element.equals(other.element());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.element);
    }

    public String toString() {
        return this.element().getSimpleName().toString();
    }
}

