/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.processor.Mirrors;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

class ElementValidator {
    private final Element element;
    private final Messager messager;
    private boolean hasWarnings;
    private final Map<Element, String> errors;

    ElementValidator(Element element, ProcessingEnvironment processingEnvironment) {
        this.element = Objects.requireNonNull(element);
        this.messager = processingEnvironment.getMessager();
        this.errors = new LinkedHashMap<Element, String>();
    }

    void error(String message) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, message, this.element);
        this.errors.put(this.element, message);
    }

    void error(String message, Class<? extends Annotation> annotation) {
        this.printMessage(annotation, Diagnostic.Kind.ERROR, message);
        this.errors.put(this.element, message);
    }

    void warning(String message) {
        this.hasWarnings = true;
        this.messager.printMessage(Diagnostic.Kind.WARNING, message, this.element);
    }

    void warning(String message, Class<? extends Annotation> annotation) {
        this.hasWarnings = true;
        this.printMessage(annotation, Diagnostic.Kind.WARNING, message);
    }

    private void printMessage(Class<? extends Annotation> annotation, Diagnostic.Kind kind, String message) {
        String name = annotation.getName();
        Optional<? extends AnnotationMirror> mirror = Mirrors.findAnnotationMirror(this.element, name);
        if (mirror.isPresent()) {
            this.messager.printMessage(kind, message, this.element, mirror.get());
        } else {
            this.messager.printMessage(kind, message);
        }
    }

    boolean hasWarnings() {
        return this.hasWarnings;
    }

    boolean hasErrors() {
        return !this.errors.values().isEmpty();
    }

    static boolean hasErrors(Set<ElementValidator> validators) {
        for (ElementValidator validator : validators) {
            if (!validator.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.errors.entrySet().forEach(entry -> sb.append(((Element)entry.getKey()).getSimpleName()).append(" : ").append((String)entry.getValue()));
        return sb.toString();
    }
}

