/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.ForeignKey;
import io.requery.meta.Cardinality;
import io.requery.processor.AssociativeEntityDescriptor;
import io.requery.processor.AttributeDescriptor;
import io.requery.processor.ElementValidator;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.EntityGraph;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.util.Types;

class EntityGraphValidator {
    private final ProcessingEnvironment processingEnvironment;
    private final EntityGraph graph;

    EntityGraphValidator(ProcessingEnvironment processingEnvironment, EntityGraph graph) {
        this.processingEnvironment = processingEnvironment;
        this.graph = graph;
    }

    Set<ElementValidator> validate() {
        LinkedHashSet<ElementValidator> results = new LinkedHashSet<ElementValidator>();
        for (EntityDescriptor entity : this.graph.entities()) {
            results.addAll(this.validateEntity(entity));
        }
        return results;
    }

    private Set<ElementValidator> validateEntity(EntityDescriptor entity) {
        LinkedHashSet<ElementValidator> results = new LinkedHashSet<ElementValidator>();
        for (AttributeDescriptor attributeDescriptor : entity.attributes()) {
            ElementValidator validator;
            block12: {
                block8: {
                    block9: {
                        Set<AttributeDescriptor> mappings;
                        EntityDescriptor referenced;
                        block13: {
                            block10: {
                                block11: {
                                    validator = new ElementValidator(attributeDescriptor.element(), this.processingEnvironment);
                                    if (attributeDescriptor.cardinality() == null) break block8;
                                    Optional<EntityDescriptor> referencingEntity = this.graph.referencingEntity(attributeDescriptor);
                                    if (!referencingEntity.isPresent()) break block9;
                                    referenced = referencingEntity.get();
                                    mappings = this.graph.mappedAttributes(entity, attributeDescriptor, referenced);
                                    if (!mappings.isEmpty()) break block10;
                                    if (attributeDescriptor.cardinality() != Cardinality.ONE_TO_ONE || attributeDescriptor.isForeignKey()) break block11;
                                    validator.error("Single sided @OneToOne should specify @ForeignKey/@JoinColumn");
                                    break block12;
                                }
                                if (attributeDescriptor.cardinality() != Cardinality.ONE_TO_MANY) break block12;
                                validator.error("Corresponding @OneToMany relation not present in mapped entity");
                                break block12;
                            }
                            if (mappings.size() != 1) break block13;
                            AttributeDescriptor mapped = mappings.iterator().next();
                            this.validateRelationship(validator, attributeDescriptor, mapped);
                            break block12;
                        }
                        if (mappings.size() <= 1) break block12;
                        validator.warning(mappings.size() + " mappings found for: " + attributeDescriptor + " -> " + referenced.typeName());
                        break block12;
                    }
                    validator.warning("Couldn't find referenced element for " + attributeDescriptor);
                    break block12;
                }
                Types types = this.processingEnvironment.getTypeUtils();
                for (EntityDescriptor descriptor : this.graph.entities()) {
                    if (!types.isSubtype(descriptor.element().asType(), attributeDescriptor.typeMirror()) || attributeDescriptor.converterName() != null || attributeDescriptor.isTransient()) continue;
                    validator.error("Entity reference missing relationship annotation");
                }
            }
            if (attributeDescriptor.isForeignKey()) {
                Optional<EntityDescriptor> referenced = this.graph.referencingEntity(attributeDescriptor);
                if (referenced.isPresent()) {
                    Optional<? extends AttributeDescriptor> referencedElement = this.graph.referencingAttribute(attributeDescriptor, referenced.get());
                    if (!referencedElement.isPresent()) {
                        validator.warning("Couldn't find referenced element " + referenced.get().typeName() + " for " + attributeDescriptor);
                    } else {
                        referenced.get().attributes().stream().filter(AttributeDescriptor::isForeignKey).map(this.graph::referencingEntity).filter(Optional::isPresent).map(Optional::get).filter(entity::equals).findAny().ifPresent(other -> validator.warning("Circular Foreign Key reference found between " + entity.typeName() + " and " + other.typeName(), ForeignKey.class));
                    }
                } else if (attributeDescriptor.cardinality() != null) {
                    validator.error("Couldn't find referenced attribute " + attributeDescriptor.referencedColumn() + " for " + attributeDescriptor);
                }
            }
            if (!validator.hasErrors() && !validator.hasWarnings()) continue;
            results.add(validator);
        }
        return results;
    }

    private void validateRelationship(ElementValidator validator, AttributeDescriptor source, AttributeDescriptor mapped) {
        Cardinality expectedCardinality;
        Cardinality sourceCardinality = source.cardinality();
        Cardinality mappedCardinality = mapped.cardinality();
        switch (sourceCardinality) {
            case ONE_TO_ONE: {
                expectedCardinality = Cardinality.ONE_TO_ONE;
                break;
            }
            case ONE_TO_MANY: {
                expectedCardinality = Cardinality.MANY_TO_ONE;
                break;
            }
            case MANY_TO_ONE: {
                expectedCardinality = Cardinality.ONE_TO_MANY;
                break;
            }
            case MANY_TO_MANY: {
                expectedCardinality = Cardinality.MANY_TO_MANY;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (mappedCardinality != expectedCardinality && mapped.cardinality() != null) {
            String message = this.mappingErrorMessage(source, mapped, expectedCardinality);
            validator.error(message);
        } else if (sourceCardinality == Cardinality.MANY_TO_MANY) {
            Optional<AssociativeEntityDescriptor> sourceAssociation = source.associativeEntity();
            Optional<AssociativeEntityDescriptor> mappedAssociation = mapped.associativeEntity();
            if (!sourceAssociation.isPresent() && !mappedAssociation.isPresent()) {
                validator.error("One side of the ManyToMany relationship must specify the @JunctionTable/@JoinTable annotation");
            }
            if (sourceAssociation.isPresent() && mappedAssociation.isPresent()) {
                validator.error("@JunctionTable should be specified on only one side of a ManyToMany relationship");
            }
        } else if (sourceCardinality == Cardinality.ONE_TO_ONE) {
            if (!source.isForeignKey() && !mapped.isForeignKey()) {
                validator.error("One side of the OneToOne relationship must specify the @ForeignKey/@JoinColumn annotation");
            }
            if (source.isForeignKey() && mapped.isForeignKey() && source != mapped) {
                validator.error("Only one side of the OneToOne relationship can specify the @ForeignKey/@JoinColumn annotation");
            }
        }
    }

    private String mappingErrorMessage(AttributeDescriptor source, AttributeDescriptor mapped, Cardinality expected) {
        String sourceType = source.cardinality().annotationClass().getSimpleName();
        String mappedType = mapped.cardinality().annotationClass().getSimpleName();
        String expectedType = expected.annotationClass().getSimpleName();
        String message = "%s with cardinality %s incorrectly mapped to %s having cardinality %s, expected %s";
        return String.format(message, source, sourceType, mapped, mappedType, expectedType);
    }
}

