/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.CascadeAction;
import io.requery.ReferentialAction;
import io.requery.com.squareup.javapoet.ClassName;
import io.requery.com.squareup.javapoet.CodeBlock;
import io.requery.com.squareup.javapoet.FieldSpec;
import io.requery.com.squareup.javapoet.MethodSpec;
import io.requery.com.squareup.javapoet.ParameterizedTypeName;
import io.requery.com.squareup.javapoet.TypeName;
import io.requery.com.squareup.javapoet.TypeSpec;
import io.requery.meta.Attribute;
import io.requery.meta.Cardinality;
import io.requery.meta.NumericAttribute;
import io.requery.meta.QueryAttribute;
import io.requery.meta.QueryExpression;
import io.requery.meta.StringAttribute;
import io.requery.meta.Type;
import io.requery.meta.TypeBuilder;
import io.requery.processor.AssociativeEntityDescriptor;
import io.requery.processor.AttributeDescriptor;
import io.requery.processor.CodeGeneration;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.EntityGenerator;
import io.requery.processor.EntityGraph;
import io.requery.processor.EntityPartGenerator;
import io.requery.processor.GeneratedProperty;
import io.requery.processor.ImmutableAnnotationKind;
import io.requery.processor.JoinEntityGenerator;
import io.requery.processor.Mirrors;
import io.requery.processor.Names;
import io.requery.proxy.BooleanProperty;
import io.requery.proxy.ByteProperty;
import io.requery.proxy.DoubleProperty;
import io.requery.proxy.EntityProxy;
import io.requery.proxy.FloatProperty;
import io.requery.proxy.IntProperty;
import io.requery.proxy.LongProperty;
import io.requery.proxy.Property;
import io.requery.proxy.PropertyState;
import io.requery.proxy.ShortProperty;
import io.requery.query.Order;
import io.requery.util.function.Function;
import io.requery.util.function.Supplier;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

class EntityMetaGenerator
extends EntityPartGenerator {
    private final HashSet<String> attributeNames = new HashSet();
    private final HashSet<String> expressionNames = new HashSet();

    EntityMetaGenerator(ProcessingEnvironment processingEnvironment, EntityGraph graph, EntityDescriptor entity) {
        super(processingEnvironment, graph, entity);
    }

    void generate(TypeSpec.Builder builder) {
        boolean metadataOnly = this.entity.isImmutable() || this.entity.isUnimplementable();
        ClassName targetName = metadataOnly ? ClassName.get(this.entity.element()) : this.typeName;
        LinkedList generatedEmbeddedTypes = new LinkedList();
        this.entity.attributes().stream().filter(attribute -> !attribute.isTransient()).forEach(attribute -> {
            String fieldName = EntityMetaGenerator.upperCaseUnderscoreRemovePrefixes(attribute.fieldName());
            if (attribute.isForeignKey() && attribute.cardinality() != null) {
                this.graph.referencingEntity((AttributeDescriptor)attribute).flatMap(entity -> this.graph.referencingAttribute((AttributeDescriptor)attribute, (EntityDescriptor)entity)).ifPresent(foreignKey -> {
                    String name = fieldName + "_ID";
                    TypeMirror mirror = foreignKey.typeMirror();
                    builder.addField(this.generateAttribute((AttributeDescriptor)attribute, null, targetName, name, mirror, true));
                    this.expressionNames.add(name);
                });
            }
            if (attribute.isEmbedded()) {
                this.graph.embeddedDescriptorOf((AttributeDescriptor)attribute).ifPresent(embedded -> {
                    this.generateEmbeddedAttributes((AttributeDescriptor)attribute, (EntityDescriptor)embedded, builder, targetName);
                    if (!generatedEmbeddedTypes.contains(embedded.typeName())) {
                        generatedEmbeddedTypes.add(embedded.typeName());
                        this.generateEmbeddedEntity((EntityDescriptor)embedded);
                    }
                });
            } else {
                TypeMirror mirror = attribute.typeMirror();
                builder.addField(this.generateAttribute((AttributeDescriptor)attribute, null, targetName, fieldName, mirror, false));
                this.attributeNames.add(fieldName);
            }
        });
        this.generateType(builder, targetName);
    }

    private void generateType(TypeSpec.Builder builder, TypeName targetName) {
        StringJoiner joiner;
        CodeBlock.Builder block = CodeBlock.builder().add("new $T<$T>($T.class, $S)\n", TypeBuilder.class, targetName, targetName, this.entity.tableName());
        block.add(".setBaseType($T.class)\n", ClassName.get(this.typeElement)).add(".setCacheable($L)\n", this.entity.isCacheable()).add(".setImmutable($L)\n", this.entity.isImmutable()).add(".setReadOnly($L)\n", this.entity.isReadOnly()).add(".setStateless($L)\n", this.entity.isStateless()).add(".setView($L)\n", this.entity.isView());
        String factoryName = this.entity.classFactoryName();
        if (!Names.isEmpty(factoryName)) {
            block.add(".setFactory(new $L())\n", ClassName.bestGuess(factoryName));
        } else if (this.entity.isImmutable()) {
            TypeSpec.Builder supplier = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(EntityMetaGenerator.parameterizedTypeName(Supplier.class, this.typeName));
            supplier.addMethod(CodeGeneration.overridePublicMethod("get").returns(this.typeName).addStatement("return new $T()", this.typeName).build());
            block.add(".setBuilderFactory($L)\n", supplier.build());
            MethodSpec.Builder applyMethod = CodeGeneration.overridePublicMethod("apply").addParameter(this.typeName, "value", new Modifier[0]).returns(targetName);
            this.entity.attributes().stream().filter(AttributeDescriptor::isEmbedded).forEach(attribute -> this.graph.embeddedDescriptorOf((AttributeDescriptor)attribute).ifPresent(embedded -> embedded.builderType().ifPresent(type -> {
                String fieldName = attribute.fieldName() + "Builder";
                String methodName = attribute.setterName();
                applyMethod.addStatement("value.builder.$L(value.$L.build())", methodName, fieldName);
            })));
            applyMethod.addStatement(this.entity.builderType().isPresent() ? "return value.builder.build()" : "return value.build()", new Object[0]);
            TypeSpec.Builder buildFunction = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(EntityMetaGenerator.parameterizedTypeName(Function.class, this.typeName, targetName)).addMethod(applyMethod.build());
            block.add(".setBuilderFunction($L)\n", buildFunction.build());
        } else {
            TypeSpec.Builder typeFactory = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(EntityMetaGenerator.parameterizedTypeName(Supplier.class, targetName)).addMethod(CodeGeneration.overridePublicMethod("get").addStatement("return new $T()", targetName).returns(targetName).build());
            block.add(".setFactory($L)\n", typeFactory.build());
        }
        ParameterizedTypeName proxyType = EntityMetaGenerator.parameterizedTypeName(EntityProxy.class, targetName);
        TypeSpec.Builder proxyProvider = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(EntityMetaGenerator.parameterizedTypeName(Function.class, targetName, proxyType));
        MethodSpec.Builder proxyFunction = CodeGeneration.overridePublicMethod("apply").addParameter(targetName, "entity", new Modifier[0]).returns(proxyType);
        if (this.entity.isImmutable() || this.entity.isUnimplementable()) {
            proxyFunction.addStatement("return new $T(entity, $L)", proxyType, "$TYPE");
        } else {
            proxyFunction.addStatement("return entity.$L", "$proxy");
        }
        proxyProvider.addMethod(proxyFunction.build());
        block.add(".setProxyProvider($L)\n", proxyProvider.build());
        if (this.entity.tableAttributes().length > 0) {
            joiner = new StringJoiner(",", "new String[] {", "}");
            for (String attribute2 : this.entity.tableAttributes()) {
                joiner.add("\"" + attribute2 + "\"");
            }
            block.add(".setTableCreateAttributes($L)\n", joiner.toString());
        }
        if (this.entity.tableUniqueIndexes().length > 0) {
            joiner = new StringJoiner(",", "new String[] {", "}");
            for (String attribute2 : this.entity.tableUniqueIndexes()) {
                joiner.add("\"" + attribute2 + "\"");
            }
            block.add(".setTableUniqueIndexes($L)\n", joiner.toString());
        }
        this.attributeNames.forEach(name -> block.add(".addAttribute($L)\n", name));
        this.expressionNames.forEach(name -> block.add(".addExpression($L)\n", name));
        block.add(".build()", new Object[0]);
        ParameterizedTypeName type = EntityMetaGenerator.parameterizedTypeName(Type.class, targetName);
        builder.addField(FieldSpec.builder(type, "$TYPE", Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("$L", block.build()).build());
    }

    private void generateEmbeddedAttributes(AttributeDescriptor parent, EntityDescriptor embedded, TypeSpec.Builder builder, TypeName targetName) {
        embedded.attributes().forEach(attribute -> {
            String fieldName = Names.upperCaseUnderscore(EntityMetaGenerator.embeddedAttributeName(parent, attribute));
            TypeMirror mirror = attribute.typeMirror();
            builder.addField(this.generateAttribute((AttributeDescriptor)attribute, parent, targetName, fieldName, mirror, false));
            this.attributeNames.add(fieldName);
        });
    }

    private void generateEmbeddedEntity(EntityDescriptor embedded) {
        try {
            new EntityGenerator(this.processingEnv, this.graph, embedded, this.entity).generate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private FieldSpec generateAttribute(AttributeDescriptor attribute, AttributeDescriptor parent, TypeName targetName, String fieldName, TypeMirror mirror, boolean expression) {
        StringJoiner joiner;
        ParameterizedTypeName type;
        TypeName typeName;
        TypeMirror typeMirror = mirror;
        if (attribute.isIterable()) {
            typeMirror = EntityMetaGenerator.tryFirstTypeArgument(typeMirror);
            typeName = this.parameterizedCollectionName(attribute.typeMirror());
        } else if (attribute.isOptional()) {
            typeMirror = EntityMetaGenerator.tryFirstTypeArgument(typeMirror);
            typeName = TypeName.get(typeMirror);
        } else {
            typeName = this.nameResolver.generatedTypeNameOf(typeMirror).orElse(null);
        }
        if (typeName == null) {
            typeName = this.boxedTypeName(typeMirror);
        }
        ClassName attributeType = null;
        boolean useKotlinDelegate = false;
        if (expression) {
            type = EntityMetaGenerator.parameterizedTypeName(QueryExpression.class, typeName);
        } else {
            boolean isQueryable;
            boolean bl = isQueryable = attribute.cardinality() == null || attribute.isForeignKey();
            if (isQueryable) {
                String kotlinDelegate;
                Class<StringAttribute> attributeClass;
                switch (attribute.getType()) {
                    case STRING: {
                        attributeClass = StringAttribute.class;
                        kotlinDelegate = "StringAttributeDelegate";
                        break;
                    }
                    case NUMERIC: {
                        attributeClass = NumericAttribute.class;
                        kotlinDelegate = "NumericAttributeDelegate";
                        break;
                    }
                    default: {
                        attributeClass = QueryAttribute.class;
                        kotlinDelegate = "AttributeDelegate";
                    }
                }
                attributeType = ClassName.get(attributeClass);
                TypeElement delegateType = this.elements.getTypeElement("io.requery.meta." + kotlinDelegate);
                if (delegateType != null) {
                    attributeType = ClassName.get(delegateType);
                    useKotlinDelegate = true;
                }
            } else {
                attributeType = ClassName.get(Attribute.class);
            }
            type = ParameterizedTypeName.get(attributeType, targetName, typeName);
        }
        CodeBlock.Builder builder = CodeBlock.builder();
        String attributeName = attribute.name();
        if (parent != null && parent.isEmbedded()) {
            attributeName = EntityMetaGenerator.embeddedAttributeName(parent, attribute);
        }
        if (attribute.isIterable()) {
            typeMirror = EntityMetaGenerator.tryFirstTypeArgument(typeMirror);
            TypeName name2 = this.nameResolver.tryGeneratedTypeName(typeMirror);
            TypeElement collection = (TypeElement)this.types.asElement(attribute.typeMirror());
            ParameterizedTypeName builderName = EntityMetaGenerator.parameterizedTypeName(attribute.builderClass(), targetName, typeName, name2);
            builder.add("\nnew $T($S, $T.class, $T.class)\n", builderName, attributeName, ClassName.get(collection), name2);
        } else if (attribute.isMap() && attribute.cardinality() != null) {
            List<TypeMirror> parameters = Mirrors.listGenericTypeArguments(typeMirror);
            TypeName keyName = TypeName.get(parameters.get(0));
            typeMirror = parameters.get(1);
            TypeName valueName = this.nameResolver.tryGeneratedTypeName(typeMirror);
            TypeElement valueElement = (TypeElement)this.types.asElement(attribute.typeMirror());
            ParameterizedTypeName builderName = EntityMetaGenerator.parameterizedTypeName(attribute.builderClass(), targetName, typeName, keyName, valueName);
            builder.add("\nnew $T($S, $T.class, $T.class, $T.class)\n", builderName, attributeName, ClassName.get(valueElement), keyName, valueName);
        } else {
            String statement;
            ParameterizedTypeName builderName = EntityMetaGenerator.parameterizedTypeName(attribute.builderClass(), targetName, typeName);
            TypeName classType = typeName;
            if (typeMirror.getKind().isPrimitive()) {
                classType = TypeName.get(typeMirror);
            }
            if (Mirrors.listGenericTypeArguments(typeMirror).size() > 0) {
                classType = TypeName.get(this.types.erasure(typeMirror));
                statement = "\nnew $T($S, (Class)$T.class)\n";
            } else {
                statement = "\nnew $T($S, $T.class)\n";
            }
            builder.add(statement, builderName, attributeName, classType);
        }
        if (!expression) {
            this.generateProperties(attribute, parent, typeMirror, targetName, typeName, builder);
        }
        if (attribute.isKey()) {
            builder.add(".setKey(true)\n", new Object[0]);
        }
        builder.add(".setGenerated($L)\n", attribute.isGenerated());
        builder.add(".setReadOnly($L)\n", attribute.isReadOnly());
        builder.add(".setLazy($L)\n", attribute.isLazy());
        builder.add(".setNullable($L)\n", attribute.isNullable());
        builder.add(".setUnique($L)\n", attribute.isUnique());
        if (!Names.isEmpty(attribute.defaultValue())) {
            builder.add(".setDefaultValue($S)\n", attribute.defaultValue());
        }
        if (!Names.isEmpty(attribute.collate())) {
            builder.add(".setCollate($S)\n", attribute.collate());
        }
        if (attribute.columnLength() != null) {
            builder.add(".setLength($L)\n", attribute.columnLength());
        }
        if (!Names.isEmpty(attribute.definition())) {
            builder.add(".setDefinition($S)\n", attribute.definition());
        }
        if (attribute.isVersion()) {
            builder.add(".setVersion($L)\n", attribute.isVersion());
        }
        if (attribute.converterName() != null) {
            builder.add(".setConverter(new $L())\n", attribute.converterName());
        }
        if (attribute.isForeignKey()) {
            builder.add(".setForeignKey($L)\n", attribute.isForeignKey());
            Optional<EntityDescriptor> referencedType = this.graph.referencingEntity(attribute);
            referencedType.ifPresent(referenced -> {
                builder.add(".setReferencedClass($T.class)\n", referenced.isImmutable() ? TypeName.get(referenced.element().asType()) : this.nameResolver.typeNameOf((EntityDescriptor)referenced));
                this.graph.referencingAttribute(attribute, (EntityDescriptor)referenced).ifPresent(referencedAttribute -> {
                    String name = EntityMetaGenerator.upperCaseUnderscoreRemovePrefixes(referencedAttribute.fieldName());
                    TypeSpec provider = CodeGeneration.createAnonymousSupplier(ClassName.get(Attribute.class), CodeBlock.builder().addStatement("return $T.$L", this.nameResolver.typeNameOf((EntityDescriptor)referenced), name).build());
                    builder.add(".setReferencedAttribute($L)\n", provider);
                });
            });
        }
        if (attribute.isIndexed()) {
            builder.add(".setIndexed($L)\n", attribute.isIndexed());
            if (!attribute.indexNames().isEmpty()) {
                joiner = new StringJoiner(",");
                attribute.indexNames().forEach(name -> joiner.add("$S"));
                builder.add(".setIndexNames(" + joiner + ")\n", attribute.indexNames().toArray());
            }
        }
        if (attribute.deleteAction() != null) {
            builder.add(".setDeleteAction($T.$L)\n", ClassName.get(ReferentialAction.class), attribute.deleteAction());
        }
        if (attribute.updateAction() != null) {
            builder.add(".setUpdateAction($T.$L)\n", ClassName.get(ReferentialAction.class), attribute.updateAction());
        }
        if (!attribute.cascadeActions().isEmpty()) {
            joiner = new StringJoiner(",");
            attribute.cascadeActions().forEach(action -> joiner.add("$T.$L"));
            int index = 0;
            ClassName cascadeClass = ClassName.get(CascadeAction.class);
            Object[] args = new Object[attribute.cascadeActions().size() * 2];
            for (CascadeAction action2 : attribute.cascadeActions()) {
                args[index++] = cascadeClass;
                args[index++] = action2;
            }
            builder.add(".setCascadeAction(" + joiner + ")\n", args);
        }
        if (attribute.cardinality() != null) {
            if (!expression) {
                builder.add(".setCardinality($T.$L)\n", ClassName.get(Cardinality.class), attribute.cardinality());
            }
            this.graph.referencingEntity(attribute).ifPresent(referenced -> {
                Set<AttributeDescriptor> mappings = this.graph.mappedAttributes(this.entity, attribute, (EntityDescriptor)referenced);
                if (attribute.cardinality() == Cardinality.MANY_TO_MANY) {
                    this.generateJunctionType(attribute, (EntityDescriptor)referenced, mappings).ifPresent(name -> builder.add(".setReferencedClass($T.class)\n", name));
                }
                if (mappings.size() == 1) {
                    AttributeDescriptor mapped = mappings.iterator().next();
                    String staticMemberName = EntityMetaGenerator.upperCaseUnderscoreRemovePrefixes(mapped.fieldName());
                    TypeSpec provider = CodeGeneration.createAnonymousSupplier(ClassName.get(Attribute.class), CodeBlock.builder().addStatement("return $T.$L", this.nameResolver.typeNameOf((EntityDescriptor)referenced), staticMemberName).build());
                    builder.add(".setMappedAttribute($L)\n", provider);
                }
                if (attribute.orderBy() != null) {
                    referenced.attributes().stream().filter(entry -> entry.name().equals(attribute.orderBy())).findFirst().ifPresent(orderBy -> {
                        String staticMemberName = EntityMetaGenerator.upperCaseUnderscoreRemovePrefixes(orderBy.fieldName());
                        TypeSpec provider = CodeGeneration.createAnonymousSupplier(ClassName.get(Attribute.class), CodeBlock.builder().addStatement("return $T.$L", this.nameResolver.typeNameOf((EntityDescriptor)referenced), staticMemberName).build());
                        builder.add(".setOrderByAttribute($L)\n", provider);
                        builder.add(".setOrderByDirection($T.$L)\n", ClassName.get(Order.class), attribute.orderByDirection());
                    });
                }
            });
        }
        switch (attribute.getType()) {
            case DEFAULT: {
                builder.add(".build()", new Object[0]);
                break;
            }
            case STRING: {
                builder.add(".buildString()", new Object[0]);
                break;
            }
            case NUMERIC: {
                builder.add(".buildNumeric()", new Object[0]);
            }
        }
        FieldSpec.Builder field = FieldSpec.builder(type, fieldName, Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
        if (useKotlinDelegate) {
            return field.initializer("new $T($L)", attributeType, builder.build()).build();
        }
        return field.initializer("$L", builder.build()).build();
    }

    private Optional<TypeName> generateJunctionType(AttributeDescriptor attribute, EntityDescriptor referenced, Set<AttributeDescriptor> mappings) {
        TypeName typeName = null;
        Optional<AssociativeEntityDescriptor> descriptor = attribute.associativeEntity();
        if (descriptor.isPresent()) {
            Optional<TypeMirror> mirror = descriptor.get().type();
            if (mirror.isPresent()) {
                typeName = this.guessAnyTypeName(this.entity.typeName().packageName(), mirror.get());
            } else {
                this.graph.referencingEntity(attribute).ifPresent(referencing -> {
                    JoinEntityGenerator generator = new JoinEntityGenerator(this.processingEnv, this.nameResolver, this.entity, (EntityDescriptor)referencing, attribute);
                    try {
                        generator.generate();
                    }
                    catch (IOException e) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.toString());
                        throw new RuntimeException(e);
                    }
                });
                typeName = this.nameResolver.joinEntityName(descriptor.get(), this.entity, referenced);
            }
        } else if (mappings.size() == 1 && (descriptor = mappings.iterator().next().associativeEntity()).isPresent()) {
            Optional<TypeMirror> mirror = descriptor.get().type();
            typeName = mirror.isPresent() ? this.guessAnyTypeName(this.entity.typeName().packageName(), mirror.get()) : this.nameResolver.joinEntityName(descriptor.get(), referenced, this.entity);
        }
        return Optional.ofNullable(typeName);
    }

    private void generateProperties(AttributeDescriptor attribute, AttributeDescriptor parent, TypeMirror typeMirror, TypeName targetName, TypeName attributeName, CodeBlock.Builder block) {
        String prefix = "";
        if (parent != null) {
            prefix = parent.getterName() + "().";
        }
        Class propertyClass = EntityMetaGenerator.propertyClassFor(typeMirror);
        ParameterizedTypeName propertyType = EntityMetaGenerator.propertyName(propertyClass, targetName, attributeName);
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(propertyType);
        boolean isNullable = typeMirror.getKind().isPrimitive() && attribute.isNullable();
        boolean useGetter = this.entity.isUnimplementable() || this.entity.isImmutable();
        boolean useSetter = this.entity.isUnimplementable();
        String getName = prefix + (useGetter ? attribute.getterName() : attribute.fieldName());
        String setName = prefix + (useSetter ? attribute.setterName() : attribute.fieldName());
        new GeneratedProperty(getName, setName, targetName, attributeName).setNullable(isNullable).setReadOnly(this.entity.isImmutable()).setUseMethod(useGetter).build(builder);
        if (propertyClass != Property.class) {
            TypeName primitiveType = TypeName.get(attribute.typeMirror());
            String name = Names.upperCaseFirst(attribute.typeMirror().toString());
            new GeneratedProperty(getName, setName, targetName, primitiveType).setMethodSuffix(name).setReadOnly(this.entity.isImmutable()).setUseMethod(useGetter).build(builder);
        }
        block.add(".setProperty($L)\n", builder.build());
        block.add(".setPropertyName($S)\n", attribute.element().getSimpleName());
        if (!this.entity.isStateless()) {
            ClassName stateClass = ClassName.get(PropertyState.class);
            TypeSpec.Builder stateType = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(EntityMetaGenerator.parameterizedTypeName(Property.class, targetName, stateClass));
            String fieldName = prefix + EntityMetaGenerator.propertyStateFieldName(attribute);
            new GeneratedProperty(fieldName, targetName, stateClass).build(stateType);
            block.add(".setPropertyState($L)\n", stateType.build());
        }
        if (!this.entity.isImmutable()) {
            return;
        }
        String propertyName = attribute.fieldName();
        ClassName builderName = this.typeName;
        useSetter = false;
        String parameterSuffix = null;
        Optional<TypeMirror> builderType = this.entity.builderType();
        if (builderType.isPresent()) {
            parameterSuffix = ".builder";
            if (parent != null) {
                parameterSuffix = "." + parent.fieldName() + "Builder";
            }
            propertyName = attribute.setterName();
            useSetter = true;
            TypeElement element = this.elements.getTypeElement(builderType.get().toString());
            if (element != null) {
                for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
                    List<? extends VariableElement> parameters = method.getParameters();
                    String name = Names.removeMethodPrefixes(method.getSimpleName());
                    if (Names.matchesSetter("with", name) || name.equalsIgnoreCase(attribute.fieldName()) && parameters.size() == 1) {
                        propertyName = method.getSimpleName().toString();
                    } else {
                        if (!Names.matchesSetter("set", name) && (!name.equalsIgnoreCase(attribute.fieldName()) || parameters.size() != 1)) continue;
                        propertyName = method.getSimpleName().toString();
                    }
                    break;
                }
            } else if (ImmutableAnnotationKind.IMMUTABLE.isPresent(this.entity.element())) {
                propertyName = attribute.fieldName();
                String getterName = attribute.getterName().replaceFirst("get", "");
                if (attribute.typeMirror().getKind() == TypeKind.BOOLEAN) {
                    propertyName = "is" + Names.upperCaseFirst(propertyName);
                } else if (Names.isAllUpper(getterName)) {
                    propertyName = Names.lowerCaseFirst(getterName);
                }
            }
        }
        propertyType = EntityMetaGenerator.propertyName(propertyClass, builderName, attributeName);
        TypeSpec.Builder builderProperty = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(propertyType);
        new GeneratedProperty(propertyName, builderName, attributeName).setWriteOnly(true).setUseMethod(useSetter).setAccessSuffix(parameterSuffix).build(builderProperty);
        if (propertyClass != Property.class) {
            TypeName primitiveType = TypeName.get(attribute.typeMirror());
            String name = Names.upperCaseFirst(attribute.typeMirror().toString());
            new GeneratedProperty(propertyName, builderName, primitiveType).setMethodSuffix(name).setAccessSuffix(parameterSuffix).setUseMethod(useSetter).setWriteOnly(true).build(builderProperty);
        }
        block.add(".setBuilderProperty($L)\n", builderProperty.build());
    }

    private static ParameterizedTypeName propertyName(Class type, TypeName targetName, TypeName fieldName) {
        return type == Property.class ? ParameterizedTypeName.get(ClassName.get(type), targetName, fieldName) : ParameterizedTypeName.get(ClassName.get(type), targetName);
    }

    private static Class propertyClassFor(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            switch (typeMirror.getKind()) {
                case BOOLEAN: {
                    return BooleanProperty.class;
                }
                case BYTE: {
                    return ByteProperty.class;
                }
                case SHORT: {
                    return ShortProperty.class;
                }
                case INT: {
                    return IntProperty.class;
                }
                case LONG: {
                    return LongProperty.class;
                }
                case FLOAT: {
                    return FloatProperty.class;
                }
                case DOUBLE: {
                    return DoubleProperty.class;
                }
            }
        }
        return Property.class;
    }

    private static String upperCaseUnderscoreRemovePrefixes(String name) {
        return Names.upperCaseUnderscore(Names.removeMemberPrefixes(name));
    }
}

