/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.com.squareup.javapoet.ClassName;
import io.requery.com.squareup.javapoet.ParameterizedTypeName;
import io.requery.com.squareup.javapoet.TypeName;
import io.requery.processor.AttributeDescriptor;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.EntityGraph;
import io.requery.processor.EntityNameResolver;
import io.requery.processor.Mirrors;
import io.requery.processor.Names;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class EntityPartGenerator {
    static final String PROXY_NAME = "$proxy";
    static final String TYPE_NAME = "$TYPE";
    final EntityDescriptor entity;
    final ProcessingEnvironment processingEnv;
    final Elements elements;
    final Types types;
    final TypeElement typeElement;
    final ClassName typeName;
    final EntityGraph graph;
    final EntityNameResolver nameResolver;

    EntityPartGenerator(ProcessingEnvironment processingEnv, EntityGraph graph, EntityDescriptor entity) {
        this.processingEnv = processingEnv;
        this.graph = graph;
        this.entity = entity;
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.nameResolver = new EntityNameResolver(graph);
        this.typeElement = entity.element();
        this.typeName = this.nameResolver.typeNameOf(entity);
    }

    static String propertyStateFieldName(AttributeDescriptor attribute) {
        return "$" + attribute.fieldName() + "_state";
    }

    static String attributeFieldName(AttributeDescriptor attribute) {
        return "$" + attribute.fieldName();
    }

    static String embeddedAttributeName(AttributeDescriptor parent, AttributeDescriptor embedded) {
        return Names.removeMemberPrefixes(parent.fieldName()) + "_" + Names.removeMemberPrefixes(embedded.name());
    }

    TypeName resolveAttributeType(AttributeDescriptor attribute) {
        TypeName typeName = attribute.isIterable() ? this.parameterizedCollectionName(attribute.typeMirror()) : (attribute.isOptional() ? TypeName.get(EntityPartGenerator.tryFirstTypeArgument(attribute.typeMirror())) : (TypeName)this.nameResolver.generatedTypeNameOf(attribute.typeMirror()).orElse(null));
        if (typeName == null) {
            typeName = this.boxedTypeName(attribute.typeMirror());
        }
        return typeName;
    }

    TypeName boxedTypeName(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            return TypeName.get(this.types.boxedClass((PrimitiveType)typeMirror).asType());
        }
        return TypeName.get(typeMirror);
    }

    TypeName guessAnyTypeName(String packageName, TypeMirror mirror) {
        String name = mirror.toString();
        if (name.startsWith("<any?>.")) {
            return ClassName.get(packageName, name.substring("<any?>.".length()), new String[0]);
        }
        return TypeName.get(mirror);
    }

    ParameterizedTypeName parameterizedCollectionName(TypeMirror typeMirror) {
        TypeMirror genericType = EntityPartGenerator.tryFirstTypeArgument(typeMirror);
        TypeName elementName = this.nameResolver.tryGeneratedTypeName(genericType);
        TypeElement collectionElement = (TypeElement)this.types.asElement(typeMirror);
        ClassName collectionName = ClassName.get(collectionElement);
        return ParameterizedTypeName.get(collectionName, elementName);
    }

    static TypeMirror tryFirstTypeArgument(TypeMirror typeMirror) {
        List<TypeMirror> args = Mirrors.listGenericTypeArguments(typeMirror);
        return args.isEmpty() ? typeMirror : args.get(0);
    }

    static ParameterizedTypeName parameterizedTypeName(Class<?> rawType, TypeName ... typeArguments) {
        return ParameterizedTypeName.get(ClassName.get(rawType), typeArguments);
    }
}

